/*
 * Decompiled with CFR 0.152.
 */
package nl.mrwouter.worldguard_core;

import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.List;
import nl.mrwouter.worldguard_core.Position;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public interface WorldGuard {
    public static final WorldGuard instance = null;

    public static WorldGuard getInstance() {
        return null;
    }

    default public WorldGuardPlugin getWorldGuard() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin == null || !(plugin instanceof WorldGuardPlugin)) {
            return null;
        }
        return (WorldGuardPlugin)plugin;
    }

    default public List<ProtectedRegion> getValidRegions(List<ProtectedRegion> regions) {
        return this.getValidRegions(regions, false);
    }

    default public List<ProtectedRegion> getValidRegions(List<ProtectedRegion> regions, boolean showNegativePriority) {
        ArrayList<ProtectedRegion> validRegions = new ArrayList<ProtectedRegion>();
        for (ProtectedRegion region : regions) {
            if (region.getPriority() < 0 && !showNegativePriority) continue;
            validRegions.add(region);
        }
        return validRegions;
    }

    default public ProtectedRegion getCaseInsensitiveRegion(World world, String regionname) {
        return this.getRegionManager(world).getRegions().values().stream().filter(region -> region.getId().equalsIgnoreCase(regionname)).findFirst().orElse(null);
    }

    public RegionManager getRegionManager(World var1);

    public List<ProtectedRegion> getRegions(Location var1);

    public ProtectedCuboidRegion getProtectedCubiodRegion(String var1, Location var2, Location var3);

    public Position getMinimumPosition(ProtectedRegion var1);

    public Position getMaximumPosition(ProtectedRegion var1);

    public FlagRegistry getFlagRegistry();
}

