/*
 * Decompiled with CFR 0.152.
 */
package nl.mrwouter.worldguard_7;

import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.mrwouter.worldguard_core.Position;
import nl.mrwouter.worldguard_core.RegionComparator;
import nl.mrwouter.worldguard_core.WorldGuard;
import org.bukkit.Location;

public class WorldGuard7
implements WorldGuard {
    private BlockVector3 getBlockVector3(Location location) {
        BlockVector3 position = BlockVector3.at((double)location.getX(), (double)location.getY(), (double)location.getZ());
        return position;
    }

    public RegionManager getRegionManager(org.bukkit.World world) {
        return com.sk89q.worldguard.WorldGuard.getInstance().getPlatform().getRegionContainer().get((World)new BukkitWorld(world));
    }

    public List<ProtectedRegion> getRegions(Location location) {
        BlockVector3 position = this.getBlockVector3(location);
        ArrayList<ProtectedRegion> regions = new ArrayList<ProtectedRegion>(this.getRegionManager(location.getWorld()).getApplicableRegions(position).getRegions());
        Collections.sort(regions, new RegionComparator());
        return regions;
    }

    public ProtectedCuboidRegion getProtectedCubiodRegion(String regionname, Location loc1, Location loc2) {
        ProtectedCuboidRegion region = new ProtectedCuboidRegion(regionname, this.getBlockVector3(loc1), this.getBlockVector3(loc2));
        return region;
    }

    public Position getMinimumPosition(ProtectedRegion region) {
        BlockVector3 minimum = region.getMinimumPoint();
        return new Position((double)minimum.getX(), (double)minimum.getY(), (double)minimum.getZ());
    }

    public Position getMaximumPosition(ProtectedRegion region) {
        BlockVector3 maximum = region.getMaximumPoint();
        return new Position((double)maximum.getX(), (double)maximum.getY(), (double)maximum.getZ());
    }

    public FlagRegistry getFlagRegistry() {
        return com.sk89q.worldguard.WorldGuard.getInstance().getFlagRegistry();
    }
}

