/*
 * Decompiled with CFR 0.152.
 */
package nl.mrwouter.channelmanager;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import nl.mrwouter.channelmanager.BungeeChannelListener;
import nl.mrwouter.channelmanager.MessageListener;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class ChannelManager {
    private Plugin plugin;
    private HashMap<String, MessageListener> channelListeners = new HashMap();

    public ChannelManager(Plugin plugin) {
        this.plugin = plugin;
        Bukkit.getServer().getMessenger().registerIncomingPluginChannel(plugin, "BungeeCord", (PluginMessageListener)new BungeeChannelListener(this));
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel(plugin, "BungeeCord");
    }

    protected Plugin getPlugin() {
        return this.plugin;
    }

    public void register(String name, MessageListener listener) {
        if (this.channelListeners.containsKey(name.toLowerCase())) {
            throw new IllegalArgumentException("MessageListener \"" + name + "\" already exists!");
        }
        this.channelListeners.put(name, listener);
    }

    public MessageListener getListener(String name) {
        return this.channelListeners.get(name);
    }

    public void send(String channel, String subChannel, Map<String, String> data) {
        if (!this.channelListeners.containsKey(channel)) {
            throw new IllegalArgumentException("Messagechannel \"" + channel + "\" does not exist!");
        }
        JsonObject message = this.encode(channel, subChannel, data);
        if (Bukkit.getOnlinePlayers().size() == 0) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Forward");
        out.writeUTF("ALL");
        out.writeUTF(this.plugin.getName());
        ByteArrayOutputStream msgbytes = new ByteArrayOutputStream();
        DataOutputStream msgout = new DataOutputStream(msgbytes);
        try {
            msgout.writeUTF(message.toString());
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        out.writeShort(msgbytes.toByteArray().length);
        out.write(msgbytes.toByteArray());
        Player p = (Player)Bukkit.getOnlinePlayers().iterator().next();
        p.sendPluginMessage(this.getPlugin(), "BungeeCord", out.toByteArray());
    }

    private JsonObject encode(String channel, String subChannel, Map<String, String> data) {
        JsonObject json = new JsonObject();
        json.addProperty("c", channel);
        json.addProperty("sc", subChannel);
        JsonObject dataObj = new JsonObject();
        data.entrySet().stream().forEach(entry -> dataObj.addProperty((String)entry.getKey(), (String)entry.getValue()));
        json.add("data", (JsonElement)dataObj);
        return json;
    }
}

