/*
 * Decompiled with CFR 0.152.
 */
package nl.mrwouter.channelmanager;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import nl.mrwouter.channelmanager.ChannelManager;
import nl.mrwouter.channelmanager.MessageListener;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class BungeeChannelListener
implements PluginMessageListener {
    private ChannelManager manager;

    public BungeeChannelListener(ChannelManager manager) {
        this.manager = manager;
    }

    public void onPluginMessageReceived(String string, Player player, byte[] bytes) {
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
        String subChannel = in.readUTF();
        byte[] msgbytes = new byte[in.readShort()];
        in.readFully(msgbytes);
        if (subChannel.equals(this.manager.getPlugin().getName())) {
            DataInputStream msgin = new DataInputStream(new ByteArrayInputStream(msgbytes));
            try {
                String dataStr = msgin.readUTF();
                JsonObject json = new JsonParser().parse(dataStr).getAsJsonObject();
                MessageListener targetListener = this.manager.getListener(json.get("c").getAsString());
                String localSubChannel = json.get("sc").getAsString();
                HashMap<String, String> data = new HashMap<String, String>();
                JsonObject dataObj = json.get("data").getAsJsonObject();
                dataObj.entrySet().forEach(entry -> data.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString()));
                if (!targetListener.onMessageReceive(json.get("c").getAsString(), localSubChannel, data)) {
                    this.manager.getPlugin().getLogger().severe(" [ChannelManager] " + json.get("c").getAsString() + " did not acknowledge message for subchannel " + subChannel);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

