/*
 * Decompiled with CFR 0.152.
 */
package nl.mrwouter.zermelo4j.appointments;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import nl.mrwouter.zermelo4j.appointments.AppointmentType;

public class AppointmentParticipation {
    private final long id;
    private final long start;
    private final long end;
    private final List<String> subjects;
    private final List<String> teachers;
    private final List<String> groups;
    private final List<String> locations;
    private final String remark;
    private final String changeDescription;
    private final String startTimeSlot;
    private final String endTimeSlot;
    private final Boolean cancelled;
    private final AppointmentType appointmentType;

    public AppointmentParticipation(JsonObject appointmentObject) {
        this.id = appointmentObject.get("id").getAsLong();
        this.start = appointmentObject.get("start").getAsLong();
        this.end = appointmentObject.get("end").getAsLong();
        this.startTimeSlot = appointmentObject.get("startTimeSlotName").isJsonNull() ? null : appointmentObject.get("startTimeSlotName").getAsString();
        this.endTimeSlot = appointmentObject.get("endTimeSlotName").isJsonNull() ? null : appointmentObject.get("endTimeSlotName").getAsString();
        this.subjects = StreamSupport.stream(appointmentObject.get("subjects").getAsJsonArray().spliterator(), true).map(JsonElement::getAsString).collect(Collectors.toList());
        this.teachers = StreamSupport.stream(appointmentObject.get("teachers").getAsJsonArray().spliterator(), true).map(JsonElement::getAsString).collect(Collectors.toList());
        this.groups = StreamSupport.stream(appointmentObject.get("groups").getAsJsonArray().spliterator(), true).map(JsonElement::getAsString).collect(Collectors.toList());
        this.locations = StreamSupport.stream(appointmentObject.get("locations").getAsJsonArray().spliterator(), true).map(JsonElement::getAsString).collect(Collectors.toList());
        this.appointmentType = appointmentObject.has("appointmentType") ? AppointmentType.getEnum(appointmentObject.get("appointmentType").getAsString()) : AppointmentType.getEnum(appointmentObject.get("type").getAsString());
        this.remark = appointmentObject.get("schedulerRemark").getAsString();
        this.cancelled = appointmentObject.get("cancelled").getAsBoolean();
        this.changeDescription = appointmentObject.get("changeDescription").getAsString();
    }

    public long getId() {
        return this.id;
    }

    public AppointmentType getType() {
        return this.appointmentType;
    }

    public String getStartTimeSlot() {
        return this.startTimeSlot;
    }

    public String getEndTimeSlot() {
        return this.endTimeSlot;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public List<String> getTeachers() {
        return this.teachers;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public String getRemark() {
        return this.remark;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getChangeDescription() {
        return this.changeDescription;
    }

    public JsonObject toJson() {
        JsonObject appointment = new JsonObject();
        appointment.addProperty("id", (Number)this.id);
        appointment.addProperty("start", (Number)this.start);
        appointment.addProperty("end", (Number)this.end);
        appointment.addProperty("startTimeSlot", this.startTimeSlot);
        appointment.addProperty("endTimeSlot", this.endTimeSlot);
        appointment.addProperty("teachers", String.join((CharSequence)",", this.teachers));
        appointment.addProperty("subjects", String.join((CharSequence)",", this.subjects));
        appointment.addProperty("groups", String.join((CharSequence)",", this.groups));
        appointment.addProperty("locations", String.join((CharSequence)",", this.locations));
        appointment.addProperty("appointmentType", this.appointmentType.name());
        appointment.addProperty("remark", this.remark);
        appointment.addProperty("cancelled", this.cancelled);
        appointment.addProperty("changeDescription", this.changeDescription);
        return appointment;
    }

    public String toString() {
        return this.toJson().toString();
    }
}

