/*
 * Decompiled with CFR 0.152.
 */
package nl.mrwouter.zermelo4j;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import nl.mrwouter.zermelo4j.annoucements.Announcement;
import nl.mrwouter.zermelo4j.annoucements.AnnouncementComparator;
import nl.mrwouter.zermelo4j.api.ZermeloApiException;
import nl.mrwouter.zermelo4j.api.ZermeloHttpClient;
import nl.mrwouter.zermelo4j.appointments.Appointment;
import nl.mrwouter.zermelo4j.appointments.AppointmentComparator;
import nl.mrwouter.zermelo4j.appointments.AppointmentParticipation;
import nl.mrwouter.zermelo4j.users.User;

public class ZermeloAPI {
    private final String school;
    private final String accessToken;
    private final ZermeloHttpClient zermeloHttpClient;

    private ZermeloAPI(String school, String accessToken, ZermeloHttpClient zermeloHttpClient) {
        this.school = school;
        this.accessToken = accessToken;
        this.zermeloHttpClient = zermeloHttpClient;
    }

    public static String getAccessToken(String school, String authCode) throws ZermeloApiException {
        return ZermeloAPI.getAccessToken(school, authCode, new ZermeloHttpClient());
    }

    public static String getAccessToken(String school, String authCode, ZermeloHttpClient zermeloHttpClient) throws ZermeloApiException {
        HttpResponse<String> response = zermeloHttpClient.post("/oauth/token", school, "", Map.of("grant_type", "authorization_code", "code", authCode));
        JsonElement root = JsonParser.parseString((String)response.body());
        JsonObject rootObject = root.getAsJsonObject();
        return rootObject.get("access_token").getAsString();
    }

    public static ZermeloAPI getAPI(String school, String accessToken) {
        return ZermeloAPI.getAPI(school, accessToken, new ZermeloHttpClient());
    }

    public static ZermeloAPI getAPI(String school, String accessToken, ZermeloHttpClient zermeloHttpClient) {
        return new ZermeloAPI(school, accessToken, zermeloHttpClient);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getSchool() {
        return this.school;
    }

    public ZermeloHttpClient getZermeloHttpClient() {
        return this.zermeloHttpClient;
    }

    public List<AppointmentParticipation> getAppointmentParticipations(int year, int weekNumber) throws ZermeloApiException {
        return this.getAppointmentParticipations("~me", year, weekNumber);
    }

    public List<AppointmentParticipation> getAppointmentParticipations(String user, int year, int weekNumber) throws ZermeloApiException {
        String formattedWeekNumber = String.format("%02d", weekNumber);
        HttpResponse<String> response = this.getZermeloHttpClient().get("/appointmentparticipations", this.school, this.getAccessToken(), Map.of("student", user, "week", year + formattedWeekNumber, "fields", "id,start,end,startTimeSlotName,endTimeSlotName,subjects,teachers,groups,locations,appointmentType,schedulerRemark,cancelled,changeDescription"));
        JsonElement root = JsonParser.parseString((String)response.body());
        JsonObject rootObject = root.getAsJsonObject();
        return StreamSupport.stream(rootObject.get("response").getAsJsonObject().get("data").getAsJsonArray().spliterator(), true).map(JsonElement::getAsJsonObject).map(AppointmentParticipation::new).sorted(new AppointmentComparator()).collect(Collectors.toList());
    }

    public List<Appointment> getAppointments(Date startDate, Date endDate) throws ZermeloApiException {
        return this.getAppointments("~me", startDate, endDate);
    }

    public List<Appointment> getAppointments(String user, Date startDate, Date endDate) throws ZermeloApiException {
        HttpResponse<String> httpResponse = this.getZermeloHttpClient().get("/appointments", this.school, this.accessToken, Map.of("user", user, "start", String.valueOf(startDate.getTime() / 1000L), "end", String.valueOf(endDate.getTime() / 1000L)));
        JsonElement root = JsonParser.parseString((String)httpResponse.body());
        JsonObject rootObject = root.getAsJsonObject();
        return StreamSupport.stream(rootObject.get("response").getAsJsonObject().get("data").getAsJsonArray().spliterator(), true).map(JsonElement::getAsJsonObject).map(Appointment::new).sorted(new AppointmentComparator()).collect(Collectors.toList());
    }

    public List<Announcement> getAnnouncements() throws ZermeloApiException {
        return this.getAnnouncements("~me");
    }

    public List<Announcement> getAnnouncements(String user) throws ZermeloApiException {
        HttpResponse<String> httpResponse = this.getZermeloHttpClient().get("/announcements", this.getSchool(), this.getAccessToken(), Map.of("user", user, "current", "true"));
        JsonElement root = JsonParser.parseString((String)httpResponse.body());
        JsonObject rootObject = root.getAsJsonObject();
        JsonArray data = rootObject.get("response").getAsJsonObject().get("data").getAsJsonArray();
        return StreamSupport.stream(data.spliterator(), true).map(announcementElement -> {
            JsonObject announcementObj = announcementElement.getAsJsonObject();
            long id = announcementObj.get("id").getAsLong();
            long start = announcementObj.get("start").getAsLong();
            long end = announcementObj.get("end").getAsLong();
            String title = announcementObj.get("title").getAsString();
            String text = announcementObj.get("text").getAsString();
            return new Announcement(id, start, end, title, text);
        }).sorted(new AnnouncementComparator()).collect(Collectors.toList());
    }

    public User getUser() throws ZermeloApiException {
        return this.getUser("~me");
    }

    public User getUser(String user) throws ZermeloApiException {
        HttpResponse<String> httpResponse = this.getZermeloHttpClient().get("/users/" + user, this.getSchool(), this.getAccessToken(), Collections.emptyMap());
        JsonElement root = JsonParser.parseString((String)httpResponse.body());
        System.out.println(root);
        JsonObject responseObject = root.getAsJsonObject().get("response").getAsJsonObject();
        JsonObject data = responseObject.get("data").getAsJsonArray().get(0).getAsJsonObject();
        String firstName = !data.get("firstName").isJsonNull() ? data.get("firstName").getAsString() : null;
        String lastName = !data.get("lastName").isJsonNull() ? data.get("lastName").getAsString() : null;
        String prefix = !data.get("prefix").isJsonNull() ? data.get("prefix").getAsString() : null;
        return new User(user, firstName, lastName, prefix, data.get("archived").getAsBoolean(), data.get("hasPassword").getAsBoolean(), data.get("isApplicationManager").getAsBoolean(), data.get("isStudent").getAsBoolean(), data.get("isEmployee").getAsBoolean(), data.get("isFamilyMember").getAsBoolean(), data.get("isSchoolScheduler").getAsBoolean(), data.get("isSchoolLeader").getAsBoolean(), data.get("isStudentAdministrator").getAsBoolean(), data.get("isTeamLeader").getAsBoolean(), data.get("isSectionLeader").getAsBoolean(), data.get("isMentor").getAsBoolean(), data.get("isDean").getAsBoolean());
    }
}

