/*
 * Decompiled with CFR 0.152.
 */
package nl.mrwouter.zermelo4j.users;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.AccessDeniedException;
import javax.net.ssl.HttpsURLConnection;

public class User {
    private String school;
    private String accessToken;
    private String user;
    private String firstName;
    private String lastName;
    private String prefix;
    private boolean isArchived;
    private boolean hasPassword;
    private boolean isApplicationManager;
    private boolean isStudent;
    private boolean isEmployee;
    private boolean isFamilyMember;
    private boolean isSchoolScheduler;
    private boolean isSchoolLeader;
    private boolean isStudentAdministrator;
    private boolean isTeamLeader;
    private boolean isSectionLeader;
    private boolean isMentor;
    private boolean isDean;

    public User(String school, String accessToken, String user) {
        this.school = school;
        this.accessToken = accessToken;
        JsonObject data = this.getData(user);
        this.user = user;
        this.firstName = this.getField(data, "firstName");
        this.lastName = this.getField(data, "lastName");
        this.prefix = this.getField(data, "prefix");
        this.isArchived = data.get("archived").getAsBoolean();
        this.hasPassword = data.get("hasPassword").getAsBoolean();
        this.isApplicationManager = data.get("isApplicationManager").getAsBoolean();
        this.isStudent = data.get("isStudent").getAsBoolean();
        this.isEmployee = data.get("isEmployee").getAsBoolean();
        this.isFamilyMember = data.get("isFamilyMember").getAsBoolean();
        this.isSchoolScheduler = data.get("isSchoolScheduler").getAsBoolean();
        this.isSchoolLeader = data.get("isSchoolLeader").getAsBoolean();
        this.isStudentAdministrator = data.get("isStudentAdministrator").getAsBoolean();
        this.isTeamLeader = data.get("isTeamLeader").getAsBoolean();
        this.isSectionLeader = data.get("isSectionLeader").getAsBoolean();
        this.isMentor = data.get("isMentor").getAsBoolean();
        this.isDean = data.get("isDean").getAsBoolean();
    }

    public String getUser() {
        return this.user;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public boolean isApplicationManager() {
        return this.isApplicationManager;
    }

    public boolean isStudent() {
        return this.isStudent;
    }

    public boolean isEmployee() {
        return this.isEmployee;
    }

    public boolean isFamilyMember() {
        return this.isFamilyMember;
    }

    public boolean isSchoolScheduler() {
        return this.isSchoolScheduler;
    }

    public boolean isSchoolLeader() {
        return this.isSchoolLeader;
    }

    public boolean isStudentAdministrator() {
        return this.isStudentAdministrator;
    }

    public boolean isTeamLeader() {
        return this.isTeamLeader;
    }

    public boolean isSectionLeader() {
        return this.isSectionLeader;
    }

    public boolean isMentor() {
        return this.isMentor;
    }

    public boolean isDean() {
        return this.isDean;
    }

    private JsonObject getData(String user) {
        try {
            HttpsURLConnection con = (HttpsURLConnection)new URL("https://" + this.school + ".zportal.nl/api/v3/users/" + user + "?access_token=" + this.accessToken).openConnection();
            con.setRequestMethod("GET");
            InputStream inputStream = null;
            try {
                inputStream = con.getInputStream();
            }
            catch (IOException exception) {
                inputStream = con.getErrorStream();
            }
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader streamReader = new BufferedReader(reader);
            JsonElement response = new JsonParser().parse((Reader)streamReader).getAsJsonObject().get("response");
            if (response.getAsJsonObject().get("status").getAsInt() == 403) {
                throw new AccessDeniedException("You don't have enough permissions to view user '" + user + "' or this user doesn't exist.");
            }
            JsonArray data = response.getAsJsonObject().get("data").getAsJsonArray();
            streamReader.close();
            reader.close();
            return data.get(0).getAsJsonObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String getField(JsonObject object, String field) {
        if (object.get(field).isJsonNull()) {
            return null;
        }
        return object.get(field).getAsString();
    }
}

