/*
 * Decompiled with CFR 0.152.
 */
package nl.mrwouter.zermelo4j.appointments;

import com.google.gson.JsonObject;
import java.util.List;
import nl.mrwouter.zermelo4j.appointments.AppointmentParticipationException;
import nl.mrwouter.zermelo4j.appointments.AppointmentType;

public class Appointment {
    private long id;
    private long start;
    private long end;
    private List<String> subjects;
    private List<String> teachers;
    private List<String> groups;
    private List<String> locations;
    private String remark;
    private String changeDescription;
    private String startTimeSlot;
    private String endTimeSlot;
    private Boolean isParticipation;
    private Boolean valid;
    private Boolean cancelled;
    private Boolean modified;
    private Boolean moved;
    private Boolean isNew;
    private AppointmentType appointmentType;

    public Appointment(boolean isParticipation, long id, long start, long end, String startTimeSlot, String endTimeSlot, List<String> subjects, List<String> teachers, List<String> groups, List<String> locations, AppointmentType appointmentType, String remark, Boolean valid, Boolean cancelled, Boolean modified, Boolean moved, Boolean isNew, String changeDescription) {
        this.isParticipation = isParticipation;
        this.id = id;
        this.start = start;
        this.end = end;
        this.startTimeSlot = startTimeSlot;
        this.endTimeSlot = endTimeSlot;
        this.subjects = subjects;
        this.teachers = teachers;
        this.groups = groups;
        this.locations = locations;
        this.appointmentType = appointmentType;
        this.remark = remark;
        this.valid = valid;
        this.cancelled = cancelled;
        this.modified = modified;
        this.moved = moved;
        this.isNew = isNew;
        this.changeDescription = changeDescription;
    }

    public long getId() {
        return this.id;
    }

    public AppointmentType getType() {
        return this.appointmentType;
    }

    public String getStartTimeSlot() {
        return this.startTimeSlot;
    }

    public String getEndTimeSlot() {
        return this.endTimeSlot;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public List<String> getTeachers() {
        return this.teachers;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public String getRemark() {
        return this.remark;
    }

    public boolean isValid() throws AppointmentParticipationException {
        if (this.isParticipation.booleanValue()) {
            throw new AppointmentParticipationException("Can't invoke isValid when using getAppointmentParticipations");
        }
        return this.valid;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isModified() {
        return this.isParticipation.booleanValue() ? !this.changeDescription.isEmpty() : this.modified;
    }

    public boolean isMoved() throws AppointmentParticipationException {
        if (this.isParticipation.booleanValue()) {
            throw new AppointmentParticipationException("Can't invoke isValid when using getAppointmentParticipations");
        }
        return this.moved;
    }

    public boolean isNew() throws AppointmentParticipationException {
        if (this.isParticipation.booleanValue()) {
            throw new AppointmentParticipationException("Can't invoke isValid when using getAppointmentParticipations");
        }
        return this.isNew;
    }

    public String getChangeDescription() {
        return this.changeDescription;
    }

    public String toString() {
        JsonObject appointment = new JsonObject();
        appointment.addProperty("id", (Number)this.id);
        appointment.addProperty("start", (Number)this.start);
        appointment.addProperty("end", (Number)this.end);
        appointment.addProperty("startTimeSlot", this.startTimeSlot);
        appointment.addProperty("endTimeSlot", this.endTimeSlot);
        appointment.addProperty("teachers", this.teachers.toString().replace("[", "").replace("]", ""));
        appointment.addProperty("subjects", this.subjects.toString().replace("[", "").replace("]", ""));
        appointment.addProperty("groups", this.groups.toString().replace("[", "").replace("]", ""));
        appointment.addProperty("locations", this.locations.toString().replace("[", "").replace("]", ""));
        appointment.addProperty("appointmentType", this.appointmentType.toString().replace("[", "").replace("]", ""));
        appointment.addProperty("remark", this.remark);
        appointment.addProperty("valid", this.isParticipation != false ? "?" : "" + this.valid);
        appointment.addProperty("cancelled", this.cancelled);
        appointment.addProperty("modified", this.isParticipation != false ? "?" : "" + this.modified);
        appointment.addProperty("moved", this.isParticipation != false ? "?" : "" + this.moved);
        appointment.addProperty("new", this.isParticipation != false ? "?" : "" + this.isNew);
        appointment.addProperty("changeDescription", this.changeDescription);
        return appointment.toString();
    }
}

