/*
 * Decompiled with CFR 0.152.
 */
package nl.mrwouter.zermelo4j.appointments;

import com.google.gson.JsonObject;
import java.util.List;
import nl.mrwouter.zermelo4j.appointments.AppointmentType;

public class Appointment {
    private int startTimeSlot;
    private int endTimeSlot;
    private long id;
    private long start;
    private long end;
    private List<String> subjects;
    private List<String> teachers;
    private List<String> groups;
    private List<String> locations;
    private String remark;
    private String changeDescription;
    private boolean valid;
    private boolean cancelled;
    private boolean modified;
    private boolean moved;
    private boolean isNew;
    private AppointmentType appointmentType;

    public Appointment(long id, long start, long end, int startTimeSlot, int endTimeSlot, List<String> subjects, List<String> teachers, List<String> groups, List<String> locations, AppointmentType appointmentType, String remark, boolean valid, boolean cancelled, boolean modified, boolean moved, boolean isNew, String changeDescription) {
        this.id = id;
        this.start = start;
        this.end = end;
        this.startTimeSlot = startTimeSlot;
        this.endTimeSlot = endTimeSlot;
        this.subjects = subjects;
        this.teachers = teachers;
        this.groups = groups;
        this.locations = locations;
        this.appointmentType = appointmentType;
        this.remark = remark;
        this.valid = valid;
        this.cancelled = cancelled;
        this.modified = modified;
        this.moved = moved;
        this.isNew = isNew;
        this.changeDescription = changeDescription;
    }

    public long getId() {
        return this.id;
    }

    public AppointmentType getType() {
        return this.appointmentType;
    }

    public int getStartTimeSlot() {
        return this.startTimeSlot;
    }

    public int getEndTimeSlot() {
        return this.endTimeSlot;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public List<String> getTeachers() {
        return this.teachers;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public String getRemark() {
        return this.remark;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isMoved() {
        return this.moved;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String getChangeDescription() {
        return this.changeDescription;
    }

    public String toString() {
        JsonObject appointment = new JsonObject();
        appointment.addProperty("id", (Number)this.id);
        appointment.addProperty("start", (Number)this.start);
        appointment.addProperty("end", (Number)this.end);
        appointment.addProperty("startTimeSlot", (Number)this.startTimeSlot);
        appointment.addProperty("endTimeSlot", (Number)this.endTimeSlot);
        appointment.addProperty("subjects", this.subjects.toString().replace("[", "").replace("]", ""));
        appointment.addProperty("groups", this.groups.toString().replace("[", "").replace("]", ""));
        appointment.addProperty("locations", this.locations.toString().replace("[", "").replace("]", ""));
        appointment.addProperty("appointmentType", this.appointmentType.toString().replace("[", "").replace("]", ""));
        appointment.addProperty("remark", this.remark);
        appointment.addProperty("valid", Boolean.valueOf(this.valid));
        appointment.addProperty("cancelled", Boolean.valueOf(this.cancelled));
        appointment.addProperty("modified", Boolean.valueOf(this.modified));
        appointment.addProperty("moved", Boolean.valueOf(this.moved));
        appointment.addProperty("new", Boolean.valueOf(this.isNew));
        appointment.addProperty("changeDescription", this.changeDescription);
        return appointment.toString();
    }
}

