/*
 * Decompiled with CFR 0.152.
 */
package nl.mrwouter.zermeloapi;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import nl.mrwouter.zermeloapi.annoucements.Announcement;
import nl.mrwouter.zermeloapi.appointments.Appointment;
import nl.mrwouter.zermeloapi.appointments.AppointmentType;

public class ZermeloAPI {
    private String school;
    private String accessToken;

    public static ZermeloAPI getAPI(String school, String accessToken) {
        return new ZermeloAPI(school, accessToken);
    }

    public static String getAccessToken(String school, String authCode) {
        try {
            HttpsURLConnection con = (HttpsURLConnection)new URL("https://" + school + ".zportal.nl/api/v3/oauth/token").openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.writeBytes("grant_type=authorization_code&code=" + authCode);
            wr.close();
            InputStreamReader reader = new InputStreamReader((InputStream)con.getContent());
            JsonElement root = new JsonParser().parse((Reader)reader);
            JsonObject rootobj = root.getAsJsonObject();
            reader.close();
            return rootobj.get("access_token").getAsString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ZermeloAPI(String school, String accessToken) {
        this.school = school;
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getSchool() {
        return this.school;
    }

    public List<Appointment> getAppointments(Date startDate, Date endDate) {
        return this.getAppointments("~me", startDate, endDate);
    }

    public List<Appointment> getAppointments(String user, Date startDate, Date endDate) {
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        try {
            HttpsURLConnection con = (HttpsURLConnection)new URL("https://" + this.school + ".zportal.nl/api/v3/appointments?user=" + user + "&start=" + startDate.getTime() / 1000L + "&end=" + endDate.getTime() / 1000L + "&access_token=" + this.accessToken).openConnection();
            con.setRequestMethod("GET");
            InputStream inputStream = null;
            try {
                inputStream = con.getInputStream();
            }
            catch (IOException exception) {
                inputStream = con.getErrorStream();
            }
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader streamReader = new BufferedReader(reader);
            JsonElement root = new JsonParser().parse((Reader)streamReader);
            JsonObject rootobj = root.getAsJsonObject();
            streamReader.close();
            reader.close();
            JsonArray data = rootobj.get("response").getAsJsonObject().get("data").getAsJsonArray();
            for (JsonElement appointmentElement : data) {
                Object group2;
                Object subject2;
                JsonObject appointmentObj = appointmentElement.getAsJsonObject();
                long id = appointmentObj.get("id").getAsLong();
                long start = appointmentObj.get("start").getAsLong();
                long end = appointmentObj.get("end").getAsLong();
                int startTimeSlot = appointmentObj.get("startTimeSlot").isJsonNull() ? -1 : appointmentObj.get("startTimeSlot").getAsInt();
                int endTimeSlot = appointmentObj.get("startTimeSlot").isJsonNull() ? -1 : appointmentObj.get("endTimeSlot").getAsInt();
                ArrayList<String> subjects = new ArrayList<String>();
                for (Object subject2 : appointmentObj.get("subjects").getAsJsonArray()) {
                    subjects.add(subject2.getAsString());
                }
                ArrayList<String> teachers = new ArrayList<String>();
                subject2 = appointmentObj.get("teachers").getAsJsonArray().iterator();
                while (subject2.hasNext()) {
                    JsonElement teacher = (JsonElement)subject2.next();
                    teachers.add(teacher.getAsString());
                }
                ArrayList<String> groups = new ArrayList<String>();
                for (Object group2 : appointmentObj.get("groups").getAsJsonArray()) {
                    groups.add(group2.getAsString());
                }
                ArrayList<String> locations = new ArrayList<String>();
                group2 = appointmentObj.get("locations").getAsJsonArray().iterator();
                while (group2.hasNext()) {
                    JsonElement location = (JsonElement)group2.next();
                    locations.add(location.getAsString());
                }
                AppointmentType appointmentType = AppointmentType.getEnum(appointmentObj.get("type").getAsString());
                String remark = appointmentObj.get("remark").getAsString();
                boolean valid = appointmentObj.get("valid").getAsBoolean();
                boolean cancelled = appointmentObj.get("cancelled").getAsBoolean();
                boolean modified = appointmentObj.get("modified").getAsBoolean();
                boolean moved = appointmentObj.get("moved").getAsBoolean();
                boolean isNew = appointmentObj.get("new").getAsBoolean();
                String changeDescription = appointmentObj.get("changeDescription").getAsString();
                appointments.add(new Appointment(id, start, end, startTimeSlot, endTimeSlot, subjects, teachers, groups, locations, appointmentType, remark, valid, cancelled, modified, moved, isNew, changeDescription));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return appointments;
    }

    public List<Announcement> getAnnouncements() {
        return this.getAnnouncements("~me");
    }

    public List<Announcement> getAnnouncements(String user) {
        ArrayList<Announcement> announcements = new ArrayList<Announcement>();
        try {
            HttpsURLConnection con = (HttpsURLConnection)new URL("https://" + this.school + ".zportal.nl/api/v3/announcements?user=" + user + "&current=true&access_token=" + this.accessToken).openConnection();
            con.setRequestMethod("GET");
            InputStream inputStream = null;
            try {
                inputStream = con.getInputStream();
            }
            catch (IOException exception) {
                inputStream = con.getErrorStream();
            }
            InputStreamReader reader = new InputStreamReader(inputStream);
            BufferedReader streamReader = new BufferedReader(reader);
            JsonElement root = new JsonParser().parse((Reader)streamReader);
            JsonObject rootobj = root.getAsJsonObject();
            streamReader.close();
            reader.close();
            JsonArray data = rootobj.get("response").getAsJsonObject().get("data").getAsJsonArray();
            for (JsonElement announcementElement : data) {
                JsonObject announcementObj = announcementElement.getAsJsonObject();
                long id = announcementObj.get("id").getAsLong();
                long start = announcementObj.get("start").getAsLong();
                long end = announcementObj.get("end").getAsLong();
                String title = announcementObj.get("title").getAsString();
                String text = announcementObj.get("text").getAsString();
                announcements.add(new Announcement(id, start, end, title, text));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return announcements;
    }
}

