/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.playerdata.fitness;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import nl.minetopiasdb.api.playerdata.PlayerManager;
import nl.minetopiasdb.api.playerdata.fitness.objects.OfflineFitness;
import nl.minetopiasdb.api.playerdata.fitness.objects.OnlineFitness;
import nl.minetopiasdb.api.playerdata.objects.OfflineSDBPlayer;
import nl.minetopiasdb.api.playerdata.objects.OnlineSDBPlayer;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

public class FitnessManager {
    private static FitnessManager instance;

    public static FitnessManager getInstance() {
        if (instance == null) {
            instance = new FitnessManager();
        }
        return instance;
    }

    public void loadOnlinePlayer(OnlineSDBPlayer player) {
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = connection.prepareStatement("SELECT `total`, `drinkingPoints`, `fitGainedByDrinking`, `fitGainedByWalking`, `fitGainedBySprinting`, `fitGainedBySwimming`, `fitGainedByClimbing`, `fitGainedByFlying`, `healthPoints`, `fitGainedByHealth`, `healthyFood`, `unhealthyFood`, `fitGainedByFood` FROM `Fitness` WHERE UUID=?");
            statement.setString(1, player.getUUID().toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                int total = rs.getInt("total");
                int drinkingPoints = rs.getInt("drinkingPoints");
                int fitGainedByDrinking = rs.getInt("fitGainedByDrinking");
                int fitGainedByWalking = rs.getInt("fitGainedByWalking");
                int fitGainedBySprinting = rs.getInt("fitGainedBySprinting");
                int fitGainedByClimbing = rs.getInt("fitGainedByClimbing");
                int fitGainedByFlying = rs.getInt("fitGainedByFlying");
                int fitGainedBySwimming = rs.getInt("fitGainedBySwimming");
                int healthPoints = rs.getInt("healthPoints");
                int fitGainedByHealth = rs.getInt("fitGainedByHealth");
                int healthyFood = rs.getInt("healthyFood");
                int unhealthyFood = rs.getInt("unhealthyFood");
                int fitGainedByFood = rs.getInt("fitGainedByFood");
                player.setFitness(new OnlineFitness(player.getUUID(), total, drinkingPoints, fitGainedByDrinking, fitGainedByWalking, fitGainedBySprinting, fitGainedByClimbing, fitGainedByFlying, fitGainedBySwimming, healthPoints, fitGainedByHealth, healthyFood, unhealthyFood, fitGainedByFood));
            } else {
                this.addDefaults(player.getUUID());
                this.loadOnlinePlayer(player);
            }
            rs.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void loadOfflinePlayer(OfflineSDBPlayer player) {
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = connection.prepareStatement("SELECT `total`, `drinkingPoints`, `fitGainedByDrinking`, `fitGainedByWalking`, `fitGainedBySprinting`, `fitGainedBySwimming`, `fitGainedByClimbing`, `fitGainedByFlying`, `healthPoints`, `fitGainedByHealth`, `healthyFood`, `unhealthyFood`, `fitGainedByFood` FROM `Fitness` WHERE UUID=?");
            statement.setString(1, player.getUUID().toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                int total = rs.getInt("total");
                int drinkingPoints = rs.getInt("drinkingPoints");
                int fitGainedByDrinking = rs.getInt("fitGainedByDrinking");
                int fitGainedByWalking = rs.getInt("fitGainedByWalking");
                int fitGainedBySprinting = rs.getInt("fitGainedBySprinting");
                int fitGainedByClimbing = rs.getInt("fitGainedByClimbing");
                int fitGainedByFlying = rs.getInt("fitGainedByFlying");
                int fitGainedBySwimming = rs.getInt("fitGainedBySwimming");
                int healthPoints = rs.getInt("healthPoints");
                int fitGainedByHealth = rs.getInt("fitGainedByHealth");
                int healthyFood = rs.getInt("healthyFood");
                int unhealthyFood = rs.getInt("unhealthyFood");
                int fitGainedByFood = rs.getInt("fitGainedByFood");
                player.setFitness(new OfflineFitness(player.getUUID(), total, drinkingPoints, fitGainedByDrinking, fitGainedByWalking, fitGainedBySprinting, fitGainedByClimbing, fitGainedByFlying, fitGainedBySwimming, healthPoints, fitGainedByHealth, healthyFood, unhealthyFood, fitGainedByFood));
            }
            rs.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isInDatabase(UUID uuid) {
        boolean bl;
        block8: {
            Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
            try {
                PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT rowId FROM Fitness WHERE UUID=?");
                statement.setString(1, uuid.toString());
                ResultSet result = statement.executeQuery();
                boolean hasNext = result.next();
                result.close();
                statement.close();
                bl = hasNext;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public void addDefaults(UUID uuid) {
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "INSERT INTO `Fitness`(`UUID`, `total`, `drinkingPoints`, `fitGainedByDrinking`, `fitGainedByWalking`, `fitGainedBySprinting`, `fitGainedBySwimming`, `fitGainedByClimbing`, `fitGainedByFlying`, `healthPoints`, `fitGainedByHealth`, `healthyFood`, `unhealthyFood`, `fitGainedByFood`) VALUES (?,?,0,0,0,0,0,0,0,0,0,0,0,0)");
            statement.setString(1, uuid.toString());
            statement.setInt(2, TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.O5ZsV1Ou6HrVTCb));
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void pushSetsToDatabase(UUID uuid, HashMap<String, Integer> changes) {
        if (changes.isEmpty()) {
            return;
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        Object setVal = "";
        for (String path : changes.keySet()) {
            setVal = (String)setVal + "`" + path + "`=?,";
            values.add(changes.get(path));
        }
        setVal = ((String)setVal).substring(0, ((String)setVal).length() - 1);
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = connection.prepareStatement("UPDATE Fitness SET " + (String)setVal + " WHERE `UUID`=?");
            int parameterIndex = 1;
            for (Integer change : values) {
                statement.setInt(parameterIndex, change);
                ++parameterIndex;
            }
            statement.setString(parameterIndex, uuid.toString());
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void checkStatistics(Player player) {
        if (PlayerManager.getOnlinePlayer(player.getUniqueId()).getFitness() == null) {
            return;
        }
        OnlineFitness fit = PlayerManager.getOnlinePlayer(player.getUniqueId()).getFitness();
        int walkPoints = fit.getFitGainedByWalking();
        int runPoints = fit.getFitGainedBySprinting();
        int swimPoints = fit.getFitGainedBySwimming();
        int climbPoints = fit.getFitGainedByClimbing();
        int flyPoints = fit.getFitGainedByFlying();
        if ((double)player.getStatistic(Statistic.WALK_ONE_CM) >= this.kmToCm(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.bXOqnWy17iQx7k4)) && walkPoints < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.VZXa0zqwJEH6wZu)) {
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setFitGainedByWalking(fit.getFitGainedByWalking() + 1);
            player.setStatistic(Statistic.WALK_ONE_CM, 0);
        } else if ((double)player.getStatistic(Statistic.SWIM_ONE_CM) >= this.kmToCm(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.G4ljgB8EUCJ92Xo)) && swimPoints < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.N0YspZNVUacJsUO)) {
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setFitGainedBySwimming(fit.getFitGainedBySwimming() + 1);
            player.setStatistic(Statistic.SWIM_ONE_CM, 0);
        } else if ((double)player.getStatistic(Statistic.CLIMB_ONE_CM) > this.kmToCm(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.PzYwz0IFn2kqw0T)) && climbPoints < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.nr02uuWcEk09FCG)) {
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setFitGainedByClimbing(fit.getFitGainedByClimbing() + 1);
            player.setStatistic(Statistic.CLIMB_ONE_CM, 0);
        } else if ((double)player.getStatistic(Statistic.AVIATE_ONE_CM) > this.kmToCm(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.qBJhaI9XDpDyWop)) && flyPoints < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.GwulnhqC8eP1yI8)) {
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setFitGainedByFlying(fit.getFitGainedByFlying() + 1);
            player.setStatistic(Statistic.AVIATE_ONE_CM, 0);
        } else if ((double)player.getStatistic(Statistic.SPRINT_ONE_CM) >= this.kmToCm(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.LoRZF1Q4WozEzll)) && runPoints < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.R6bbx4MODwCioin)) {
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setFitGainedBySprinting(fit.getFitGainedBySprinting() + 1);
            player.setStatistic(Statistic.SPRINT_ONE_CM, 0);
        }
        PlayerManager.getOnlinePlayer(player.getUniqueId()).updateFitnessEffects();
    }

    public void healthPointsCheck(Player player) {
        OnlineFitness fit = PlayerManager.getOnlinePlayer(player.getUniqueId()).getFitness();
        if (player.getFoodLevel() >= 18) {
            fit.setHealthPoints(fit.getHealthPoints() + TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.g0WlDqEIeoxh4jx));
        } else if (player.getFoodLevel() <= 4) {
            fit.setHealthPoints(fit.getHealthPoints() + TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.gI2dfmg4aIY38RV));
        } else if (player.getFoodLevel() <= 10) {
            fit.setHealthPoints(fit.getHealthPoints() + TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.NyTNRkR3clX7XZn));
        }
        if (fit.getHealthPoints() >= 750 && fit.getFitGainedByHealth() < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(ContainerListenerRepositoryVisitor.klqdcDeKEjHpyEL)) {
            fit.setFitGainedByHealth(fit.getFitGainedByHealth() + 1);
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setHealthPoints(0);
        }
    }

    private double kmToCm(double kilometers) {
        return kilometers * 100000.0;
    }
}

