/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.playerdata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import org.bukkit.Bukkit;

public class PrefixManager {
    private static PrefixManager instance;
    private HashMap<UUID, List<String>> cachedPrefixes = new HashMap();

    public static PrefixManager getInstance() {
        if (instance == null) {
            instance = new PrefixManager();
        }
        return instance;
    }

    public List<String> getPrefixes(UUID uuid) {
        if (this.cachedPrefixes.containsKey(uuid)) {
            return new ArrayList<String>((Collection)this.cachedPrefixes.get(uuid));
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT `prefix` FROM `Prefixes` WHERE UUID=?");
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                prefixes.add(rs.getString("prefix"));
            }
            rs.close();
            statement.close();
            this.cachedPrefixes.put(uuid, prefixes);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return new ArrayList<String>(prefixes);
    }

    public void removeFromCache(UUID uuid) {
        this.cachedPrefixes.remove(uuid);
    }

    public void addPrefix(final UUID uuid, final String prefix) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                    PreparedStatement statement = connection.prepareStatement("INSERT INTO `Prefixes` (UUID, prefix) VALUES (?, ?)");
                    statement.setString(1, uuid.toString());
                    statement.setString(2, prefix);
                    statement.execute();
                    statement.close();
                    ArrayList<String> prefixes = PrefixManager.this.cachedPrefixes.containsKey(uuid) ? PrefixManager.this.cachedPrefixes.get(uuid) : new ArrayList<String>();
                    prefixes.add(prefix);
                    PrefixManager.this.cachedPrefixes.remove(uuid);
                    PrefixManager.this.cachedPrefixes.put(uuid, prefixes);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void removePrefix(final UUID uuid, final String prefix) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                    PreparedStatement statement = connection.prepareStatement("DELETE FROM `Prefixes` WHERE UUID=? AND prefix=?");
                    statement.setString(1, uuid.toString());
                    statement.setString(2, prefix);
                    statement.execute();
                    statement.close();
                    ArrayList prefixes = PrefixManager.this.cachedPrefixes.containsKey(uuid) ? PrefixManager.this.cachedPrefixes.get(uuid) : new ArrayList();
                    prefixes.remove(prefix);
                    PrefixManager.this.cachedPrefixes.remove(uuid);
                    PrefixManager.this.cachedPrefixes.put(uuid, prefixes);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void reset(final UUID uuid) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                    PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "DELETE FROM `Prefixes` WHERE UUID=?");
                    statement.setString(1, uuid.toString());
                    statement.execute();
                    statement.close();
                    PrefixManager.this.cachedPrefixes.remove(uuid);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void swap(UUID a2, UUID b2) {
        this.removeFromCache(a2);
        this.removeFromCache(b2);
        ArrayList<Integer> rowIdsA = new ArrayList<Integer>();
        ArrayList<Integer> rowIdsB = new ArrayList<Integer>();
        try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            int i;
            Object statement;
            PreparedStatement selectA = conn.prepareStatement("SELECT rowId FROM `Prefixes` WHERE UUID=?");
            selectA.setString(1, a2.toString());
            ResultSet rsA = selectA.executeQuery();
            while (rsA.next()) {
                rowIdsA.add(rsA.getInt("rowId"));
            }
            rsA.close();
            selectA.close();
            PreparedStatement selectB = conn.prepareStatement("SELECT rowId FROM `Prefixes` WHERE UUID=?");
            selectB.setString(1, b2.toString());
            ResultSet rsB = selectB.executeQuery();
            while (rsB.next()) {
                rowIdsB.add(rsB.getInt("rowId"));
            }
            rsB.close();
            selectB.close();
            if (rowIdsA.size() > 0) {
                statement = "UPDATE `Prefixes` SET UUID=? WHERE rowId=?";
                if (rowIdsA.size() > 1) {
                    for (int i2 = 1; i2 < rowIdsA.size(); ++i2) {
                        statement = (String)statement + " OR rowId=? ";
                    }
                }
                PreparedStatement updateA = conn.prepareStatement((String)statement);
                updateA.setString(1, b2.toString());
                for (i = 0; i < rowIdsA.size(); ++i) {
                    updateA.setInt(i + 2, (Integer)rowIdsA.get(i));
                }
                updateA.execute();
                updateA.close();
            }
            if (rowIdsB.size() > 0) {
                statement = "UPDATE `Prefixes` SET UUID=? WHERE rowId=?";
                if (rowIdsB.size() > 1) {
                    for (int i3 = 1; i3 < rowIdsB.size(); ++i3) {
                        statement = (String)statement + " OR rowId=? ";
                    }
                }
                PreparedStatement updateB = conn.prepareStatement((String)statement);
                updateB.setString(1, a2.toString());
                for (i = 0; i < rowIdsB.size(); ++i) {
                    updateB.setInt(i + 2, (Integer)rowIdsB.get(i));
                }
                updateB.execute();
                updateB.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

