/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.mtplaces.abstracts;

import java.text.DecimalFormat;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.bukkit.World;

public abstract class MTPlace {
    protected String name;
    protected String color;
    protected String title;
    protected String loadingName;
    protected double averageTemperature;

    public MTPlace(String name, String color, String title, String loadingName, double averageTemperature) {
        this.name = name;
        this.color = color;
        this.title = title;
        this.loadingName = loadingName;
        this.averageTemperature = averageTemperature;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public CompletableFuture<Void> setTitle(String title) {
        return this.set("title", title).thenAccept(rows -> {
            this.title = title;
        });
    }

    public String getColor() {
        return this.color;
    }

    public CompletableFuture<Void> setColor(String color) {
        return this.set("color", color).thenAccept(rows -> {
            this.color = color;
        });
    }

    public String getLoadingName() {
        return this.loadingName;
    }

    public CompletableFuture<Void> setLoadingName(String loadingName) {
        return this.set("loadingname", loadingName).thenAccept(rows -> {
            this.loadingName = loadingName;
        });
    }

    public double getAverageTemperature() {
        return this.averageTemperature;
    }

    public CompletableFuture<Void> setAverageTemperature(double temp) {
        return this.set("temperature", temp).thenAccept(rows -> {
            this.averageTemperature = temp;
        });
    }

    public double getCurrentTemperature(World world) {
        boolean storm = world.hasStorm();
        long time = world.getTime();
        double temp = this.getAverageTemperature();
        if (time >= 0L && time < 1000L) {
            temp -= 2.31;
        } else if (time >= 1000L && time < 3000L) {
            temp -= 1.582;
        } else if (time >= 3000L && time < 5000L) {
            temp -= 0.94;
        } else if (time >= 5000L && time < 7000L) {
            temp -= 0.3403;
        } else if (time >= 7000L && time < 9000L) {
            temp += 0.22;
        } else if (time >= 9000L && time < 11000L) {
            temp += 0.86;
        } else if (time >= 11000L && time < 13000L) {
            temp += 1.43;
        } else if (time >= 13000L && time < 18000L) {
            temp += 2.12;
        } else if (time >= 18000L && time < 22000L) {
            temp += 1.43;
        } else if (time >= 22000L) {
            temp += 0.68;
        }
        return (storm ? temp - 2.23 : temp) + new Random().nextDouble() * 0.4;
    }

    public String getCurrentTemperatureFormatted(World world) {
        DecimalFormat df2 = new DecimalFormat("#.##");
        return df2.format(this.getCurrentTemperature(world)).replace(",", ".");
    }

    protected abstract CompletableFuture<Integer> set(String var1, Object var2);
}

