/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.mtplaces;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import nl.minetopiasdb.api.mtplaces.abstracts.MTWorld;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import org.bukkit.World;

public class MTWorldManager {
    private static MTWorldManager instance;
    private HashMap<String, MTWorld> worlds = null;

    public static MTWorldManager getInstance() {
        if (instance == null) {
            instance = new MTWorldManager();
            if (MTWorldManager.instance.worlds == null) {
                instance.initWorlds(false);
            }
        }
        return instance;
    }

    public CompletableFuture<Boolean> addWorld(String worldName) {
        MTWorld mtw = new MTWorld(worldName, "&3", "&l" + worldName.toUpperCase(), worldName, 21.64);
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Boolean bl;
                block14: {
                    PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "INSERT INTO `Worlds` (worldname, color, title, loadingname, temperature) VALUES (?, ?, ?, ?, ?)");
                    try {
                        statement.setString(1, mtw.getName().toLowerCase());
                        statement.setString(2, mtw.getColor());
                        statement.setString(3, mtw.getTitle());
                        statement.setString(4, mtw.getLoadingName());
                        statement.setDouble(5, mtw.getAverageTemperature());
                        bl = statement.executeUpdate() == 1;
                        if (statement == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return bl;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }).thenApply(success -> {
            if (success.booleanValue()) {
                this.worlds.put(worldName.toLowerCase(), mtw);
                if (Main.getChannelManager() != null) {
                    Main.getChannelManager().send("mtworld", "update", new HashMap());
                }
            }
            return success;
        });
    }

    public CompletableFuture<Boolean> removeWorld(String world) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Boolean bl;
                block14: {
                    PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "DELETE FROM `Worlds` WHERE LOWER(worldname)=?");
                    try {
                        statement.setString(1, world.toLowerCase());
                        bl = statement.executeUpdate() == 1;
                        if (statement == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return bl;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }).thenApply(success -> {
            if (success.booleanValue()) {
                this.worlds.remove(world.toLowerCase());
                if (Main.getChannelManager() != null) {
                    Main.getChannelManager().send("mtworld", "update", new HashMap());
                }
            }
            return success;
        });
    }

    public Collection<MTWorld> getMTWorlds() {
        return this.worlds.values();
    }

    public Collection<String> getWorldNames() {
        return this.worlds.keySet();
    }

    public boolean isSDBEnabled(World world) {
        return this.isSDBEnabled(world.getName());
    }

    public boolean isSDBEnabled(String worldName) {
        return this.getWorldNames().contains(worldName.toLowerCase());
    }

    public MTWorld getMTWorld(String worldName) {
        return this.worlds.get(worldName.toLowerCase());
    }

    public void initWorlds(boolean force) {
        if (this.worlds == null || force) {
            if (this.worlds != null) {
                this.worlds.clear();
            }
            this.worlds = this.getWorldsFromDatabase();
        }
    }

    private HashMap<String, MTWorld> getWorldsFromDatabase() {
        HashMap<String, MTWorld> worlds = new HashMap<String, MTWorld>();
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = connection.prepareStatement("SELECT worldname, title, color, loadingname, temperature FROM Worlds");
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                String worldname = result.getString("worldname").toLowerCase();
                String title = result.getString("title");
                String color = result.getString("color");
                String loadingname = result.getString("loadingname");
                double temperature = result.getDouble("temperature");
                MTWorld world = new MTWorld(worldname, color, title, loadingname, temperature);
                worlds.put(worldname, world);
            }
            result.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return worlds;
    }
}

