/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.events.bank;

import nl.minetopiasdb.api.banking.BankUtils;
import nl.minetopiasdb.api.enums.BankAccountType;
import nl.minetopiasdb.api.enums.BankPermission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class BankAccountAddUserEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private CommandSender player;
    private boolean cancelled = false;
    private int bankId;
    private OfflinePlayer addedPlayer;
    private BankAccountType accountType;
    private BankPermission permission;

    public BankAccountAddUserEvent(CommandSender player, OfflinePlayer addedPlayer, BankPermission permission, int bankId) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.player = player;
        this.bankId = bankId;
        this.accountType = BankUtils.getInstance().getBankAccount(bankId).getType();
        this.permission = permission;
        this.addedPlayer = addedPlayer;
    }

    public CommandSender getPlayer() {
        return this.player;
    }

    public OfflinePlayer getAddedPlayer() {
        return this.addedPlayer;
    }

    public BankPermission getPermission() {
        return this.permission;
    }

    public int getAccountId() {
        return this.bankId;
    }

    public BankAccountType getBankAccountType() {
        return this.accountType;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

