/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import nl.minetopiasdb.api.objects.Teleporter;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import org.bukkit.Location;

public class TeleporterManager {
    private static TeleporterManager instance;
    private List<Teleporter> teleporters = new ArrayList<Teleporter>();
    private HashMap<UUID, Location> teleporterLocations = new HashMap();
    private boolean pulledData = false;

    public static TeleporterManager getInstance() {
        if (instance == null) {
            instance = new TeleporterManager();
        }
        return instance;
    }

    public void setTeleporterLocation(UUID uuid, Location location) {
        this.teleporterLocations.remove(uuid);
        this.teleporterLocations.put(uuid, location);
    }

    public Location getTeleporterLocation(UUID uuid) {
        return this.teleporterLocations.get(uuid);
    }

    public void create(Location signLoc, Location goalLoc, double costs, int minLevel) {
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "INSERT INTO `Teleporters` (`SIGN_X`, `SIGN_Y`, `SIGN_Z`, `SIGN_WORLD`, `GOAL_X`, `GOAL_Y`, `GOAL_Z`, `PITCH`, `YAW`, `GOAL_WORLD`, `COSTS`, `MIN_LEVEL`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            int pitch = Math.round(goalLoc.getPitch());
            int yaw = Math.round(goalLoc.getYaw());
            statement.setInt(1, signLoc.getBlockX());
            statement.setInt(2, signLoc.getBlockY());
            statement.setInt(3, signLoc.getBlockZ());
            statement.setString(4, signLoc.getWorld().getName().toLowerCase());
            statement.setInt(5, goalLoc.getBlockX());
            statement.setInt(6, goalLoc.getBlockY());
            statement.setInt(7, goalLoc.getBlockZ());
            statement.setInt(8, pitch);
            statement.setInt(9, yaw);
            statement.setString(10, goalLoc.getWorld().getName().toLowerCase());
            statement.setDouble(11, costs);
            statement.setInt(12, minLevel);
            statement.execute();
            statement.close();
            this.teleporters.add(new Teleporter(signLoc.getWorld().getName().toLowerCase(), signLoc.getBlockX(), signLoc.getBlockY(), signLoc.getBlockZ(), goalLoc.getWorld().getName().toLowerCase(), goalLoc.getBlockX(), goalLoc.getBlockY(), goalLoc.getBlockZ(), costs, minLevel, pitch, yaw));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Location signLoc) {
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "DELETE FROM `Teleporters` WHERE `SIGN_X`=? AND `SIGN_Y`=? AND `SIGN_Z`=? AND `SIGN_WORLD`=?");
            statement.setInt(1, signLoc.getBlockX());
            statement.setInt(2, signLoc.getBlockY());
            statement.setInt(3, signLoc.getBlockZ());
            statement.setString(4, signLoc.getWorld().getName().toLowerCase());
            statement.execute();
            statement.close();
            for (Teleporter teleporter : new ArrayList<Teleporter>(this.teleporters)) {
                if (teleporter.getSignX() != signLoc.getBlockX() || teleporter.getSignY() != signLoc.getBlockY() || teleporter.getSignZ() != signLoc.getBlockZ() || !teleporter.getGoalWorld().equals(signLoc.getWorld().getName().toLowerCase())) continue;
                this.teleporters.remove(teleporter);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<Teleporter> getTeleporters() {
        if (!this.pulledData) {
            this.pullData();
        }
        return this.teleporters;
    }

    public void pullData() {
        this.pulledData = true;
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT * FROM `Teleporters`");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this.teleporters.add(new Teleporter(rs.getString("SIGN_WORLD"), rs.getInt("SIGN_X"), rs.getInt("SIGN_Y"), rs.getInt("SIGN_Z"), rs.getString("GOAL_WORLD"), rs.getInt("GOAL_X"), rs.getInt("GOAL_Y"), rs.getInt("GOAL_Z"), rs.getDouble("COSTS"), rs.getInt("MIN_LEVEL"), rs.getInt("PITCH"), rs.getInt("YAW")));
            }
            rs.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Teleporter getTeleporter(Location signLoc) {
        if (!this.pulledData) {
            this.pullData();
        }
        for (Teleporter teleporter : this.teleporters) {
            if (teleporter.getSignX() != signLoc.getBlockX() || teleporter.getSignY() != signLoc.getBlockY() || teleporter.getSignZ() != signLoc.getBlockZ() || !teleporter.getSignWorld().equals(signLoc.getWorld().getName().toLowerCase())) continue;
            return teleporter;
        }
        return null;
    }
}

