/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import nl.minetopiasdb.api.objects.Loan;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import nl.minetopiasdb.plugin.utils.PoolTemplateMappingStatementThread;

public class LoanManager {
    private static LoanManager singleton;

    public static LoanManager getInstance() {
        if (singleton == null) {
            singleton = new LoanManager();
        }
        return singleton;
    }

    public CompletableFuture<Integer> create(UUID uuid, double amount) {
        CompletableFuture<Integer> completableFuture = CompletableFuture.supplyAsync(() -> {
            int loanId = -1;
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = conn.prepareStatement("INSERT INTO Loans(UUID, loan_amount) VALUES (?, ?)", 1);
                statement.setString(1, uuid.toString());
                statement.setDouble(2, amount);
                statement.execute();
                ResultSet rs = statement.getGeneratedKeys();
                if (rs.next()) {
                    loanId = rs.getInt(1);
                }
                statement.close();
                rs.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            return loanId;
        });
        return completableFuture;
    }

    public CompletableFuture<Integer> setPaidOff(int id, boolean paidOff) {
        CompletableFuture<Integer> completableFuture = CompletableFuture.supplyAsync(() -> {
            int modifiedRows = 0;
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = conn.prepareStatement("UPDATE Loans SET paid_off=? WHERE loan_id=?");
                statement.setBoolean(1, paidOff);
                statement.setInt(2, id);
                modifiedRows = statement.executeUpdate();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            return modifiedRows;
        });
        return completableFuture;
    }

    public CompletableFuture<Loan> getLoanById(int id) {
        CompletableFuture<Loan> completableFuture = CompletableFuture.supplyAsync(() -> {
            Loan loan = null;
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = conn.prepareStatement("SELECT * FROM Loans WHERE loan_id=?");
                statement.setInt(1, id);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    loan = new Loan(rs.getInt("loan_id"), UUID.fromString(rs.getString("UUID")), rs.getDouble("loan_amount"), rs.getBoolean("paid_off"), this.stringToSqlTimestamp(rs.getString("created_on")));
                }
                statement.close();
                rs.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            return loan;
        });
        return completableFuture;
    }

    public CompletableFuture<List<Loan>> getLoans() {
        CompletableFuture<List<Loan>> completableFuture = CompletableFuture.supplyAsync(() -> {
            ArrayList<Loan> loans = new ArrayList<Loan>();
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Statement statement = conn.createStatement();
                ResultSet rs = statement.executeQuery("SELECT * FROM Loans");
                while (rs.next()) {
                    loans.add(new Loan(rs.getInt("loan_id"), UUID.fromString(rs.getString("UUID")), rs.getDouble("loan_amount"), rs.getBoolean("paid_off"), this.stringToSqlTimestamp(rs.getString("created_on"))));
                }
                statement.close();
                rs.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            Collections.sort(loans, new LoanComparator());
            return loans;
        });
        return completableFuture;
    }

    public CompletableFuture<List<Loan>> getLoans(UUID uuid) {
        CompletableFuture<List<Loan>> completableFuture = CompletableFuture.supplyAsync(() -> {
            ArrayList<Loan> loans = new ArrayList<Loan>();
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = conn.prepareStatement("SELECT loan_id, loan_amount, paid_off, created_on FROM Loans WHERE UUID=?");
                statement.setString(1, uuid.toString());
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    loans.add(new Loan(rs.getInt("loan_id"), uuid, rs.getDouble("loan_amount"), rs.getBoolean("paid_off"), this.stringToSqlTimestamp(rs.getString("created_on"))));
                }
                statement.close();
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Collections.sort(loans, new LoanComparator());
            return loans;
        });
        return completableFuture;
    }

    private Timestamp stringToSqlTimestamp(String dateTimeString) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        formatter.setTimeZone(TimeZone.getTimeZone(PoolTemplateMappingStatementThread.wkMvHiTHLyqFIhJ().httHooAopOc0CwK().getId()));
        Date date = new Date(0L);
        try {
            date = formatter.parse(dateTimeString);
        }
        catch (ParseException e) {
            Main.getPlugin().getLogger().severe("An error occured whilst attempting to parse created_on from Loans table");
            e.printStackTrace();
        }
        return new Timestamp(date.getTime());
    }

    private class LoanComparator
    implements Comparator<Loan> {
        private LoanComparator() {
        }

        @Override
        public int compare(Loan loan1, Loan loan2) {
            if (loan1.isPaidOff() && !loan2.isPaidOff()) {
                return 1;
            }
            if (loan2.isPaidOff() && !loan1.isPaidOff()) {
                return -1;
            }
            if (loan1.getAmount() > loan2.getAmount()) {
                return -1;
            }
            if (loan1.getAmount() < loan2.getAmount()) {
                return 1;
            }
            return 0;
        }
    }
}

