/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.playerdata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import nl.minetopiasdb.api.enums.ColorType;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;
import org.bukkit.Bukkit;

public class ColorManager {
    private static ColorManager instance;
    private HashMap<Map.Entry<UUID, ColorType>, HashMap<String, Long>> cachedColors = new HashMap();

    public static ColorManager getInstance() {
        if (instance == null) {
            instance = new ColorManager();
        }
        return instance;
    }

    public List<String> getColors(UUID uuid, ColorType type) {
        return new ArrayList<String>(this.getColorsWithExpiration(uuid, type).keySet());
    }

    public HashMap<String, Long> getColorsWithExpiration(UUID uuid, ColorType type) {
        Optional<HashMap> cachedColor = this.cachedColors.keySet().stream().filter(entry -> entry.getKey() == uuid && entry.getValue() == type).map(entry -> this.cachedColors.get(entry)).findFirst();
        if (cachedColor.isPresent()) {
            return cachedColor.get();
        }
        HashMap<String, Long> colors = new HashMap<String, Long>();
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
             PreparedStatement statement = connection.prepareStatement("SELECT `color`, `expires_at` FROM `" + type.getDatabase() + "` WHERE UUID=?");){
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                colors.put(rs.getString("color"), rs.getLong("expires_at"));
            }
            rs.close();
            statement.close();
            this.cachedColors.put(new AbstractMap.SimpleEntry<UUID, ColorType>(uuid, type), colors);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return colors;
    }

    public void removeFromCache(UUID uuid, ColorType type) {
        for (Map.Entry<UUID, ColorType> entry : new ArrayList<Map.Entry<UUID, ColorType>>(this.cachedColors.keySet())) {
            if (entry.getKey() != uuid || entry.getValue() != type) continue;
            this.cachedColors.remove(entry);
        }
    }

    public void addColor(UUID uuid, String color, ColorType type) {
        this.addColor(uuid, type, color, null);
    }

    public CompletableFuture<Boolean> addColor(UUID uuid, ColorType type, String color, Long expiration) {
        return this.addColors(uuid, type, Collections.singletonMap(color, expiration)).thenApply(i -> i == 1);
    }

    public void addColors(UUID uuid, ColorType type, String ... colors) {
        if (colors.length == 0) {
            return;
        }
        HashMap<String, Long> colorMap = new HashMap<String, Long>();
        Arrays.stream(colors).forEach(color -> colorMap.put((String)color, (Long)null));
        this.addColors(uuid, type, colorMap);
    }

    public CompletableFuture<Integer> addColors(UUID uuid, ColorType type, Map<String, Long> colors) {
        return CompletableFuture.supplyAsync(() -> {
            Integer n;
            block12: {
                Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
                try {
                    String ignore = TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().Q7xyfcjMTU7Yj0x(ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ) ? " IGNORE " : " OR IGNORE ";
                    PreparedStatement statement = connection.prepareStatement("INSERT " + ignore + " INTO `" + type.getDatabase() + "` (UUID, color, expires_at) VALUES (?, ?, ?);");
                    for (Map.Entry color : colors.entrySet()) {
                        statement.setString(1, uuid.toString());
                        statement.setString(2, (String)color.getKey());
                        if (color.getValue() == null || (Long)color.getValue() == -1L) {
                            statement.setNull(3, -5);
                        } else {
                            statement.setLong(3, (Long)color.getValue());
                        }
                        statement.addBatch();
                    }
                    int[] inserted_rows = statement.executeBatch();
                    statement.close();
                    for (Map.Entry<UUID, ColorType> entry : new ArrayList<Map.Entry<UUID, ColorType>>(this.cachedColors.keySet())) {
                        if (entry.getKey() != uuid || entry.getValue() != type) continue;
                        this.cachedColors.get(entry).putAll(colors);
                    }
                    n = IntStream.of(inserted_rows).sum();
                    if (connection == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        return 0;
                    }
                }
                connection.close();
            }
            return n;
        });
    }

    public CompletableFuture<Boolean> removeColor(UUID uuid, ColorType type, String color) {
        return CompletableFuture.supplyAsync(() -> {
            Boolean bl;
            block9: {
                Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
                try {
                    PreparedStatement statement = connection.prepareStatement("DELETE FROM `" + type.getDatabase() + "` WHERE UUID=? AND color=?");
                    statement.setString(1, uuid.toString());
                    statement.setString(2, color);
                    int rows = statement.executeUpdate();
                    statement.close();
                    for (Map.Entry<UUID, ColorType> entry : new ArrayList<Map.Entry<UUID, ColorType>>(this.cachedColors.keySet())) {
                        if (entry.getKey() != uuid || entry.getValue() != type) continue;
                        this.cachedColors.get(entry).remove(color);
                    }
                    bl = rows >= 1;
                    if (connection == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                connection.close();
            }
            return bl;
        });
    }

    public void removeColor(UUID uuid, String color, ColorType type) {
        this.removeColor(uuid, type, color);
    }

    public void reset(UUID uuid, ColorType type) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), () -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = connection.prepareStatement("DELETE FROM `" + type.getDatabase() + "` WHERE UUID=?");
                statement.setString(1, uuid.toString());
                statement.execute();
                statement.close();
                for (Map.Entry<UUID, ColorType> entry : new ArrayList<Map.Entry<UUID, ColorType>>(this.cachedColors.keySet())) {
                    if (entry.getKey() != uuid || entry.getValue() != type) continue;
                    this.cachedColors.remove(entry);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void swap(UUID a2, UUID b2, ColorType type) {
        this.removeFromCache(a2, type);
        this.removeFromCache(b2, type);
        ArrayList<Integer> rowIdsA = new ArrayList<Integer>();
        ArrayList<Integer> rowIdsB = new ArrayList<Integer>();
        try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            int i;
            String statement;
            PreparedStatement selectA = conn.prepareStatement("SELECT rowId FROM `" + type.getDatabase() + "` WHERE UUID=?");
            selectA.setString(1, a2.toString());
            ResultSet rsA = selectA.executeQuery();
            while (rsA.next()) {
                rowIdsA.add(rsA.getInt("rowId"));
            }
            rsA.close();
            selectA.close();
            PreparedStatement selectB = conn.prepareStatement("SELECT rowId FROM `" + type.getDatabase() + "` WHERE UUID=?");
            selectB.setString(1, b2.toString());
            ResultSet rsB = selectB.executeQuery();
            while (rsB.next()) {
                rowIdsB.add(rsB.getInt("rowId"));
            }
            rsB.close();
            selectB.close();
            if (rowIdsA.size() > 0) {
                statement = "UPDATE `" + type.getDatabase() + "` SET UUID=? WHERE rowId=?";
                if (rowIdsA.size() > 1) {
                    for (int i2 = 1; i2 < rowIdsA.size(); ++i2) {
                        statement = statement + " OR rowId=? ";
                    }
                }
                PreparedStatement updateA = conn.prepareStatement(statement);
                updateA.setString(1, b2.toString());
                for (i = 0; i < rowIdsA.size(); ++i) {
                    updateA.setInt(i + 2, (Integer)rowIdsA.get(i));
                }
                updateA.execute();
                updateA.close();
            }
            if (rowIdsB.size() > 0) {
                statement = "UPDATE `" + type.getDatabase() + "` SET UUID=? WHERE rowId=?";
                if (rowIdsB.size() > 1) {
                    for (int i3 = 1; i3 < rowIdsB.size(); ++i3) {
                        statement = statement + " OR rowId=? ";
                    }
                }
                PreparedStatement updateB = conn.prepareStatement(statement);
                updateB.setString(1, a2.toString());
                for (i = 0; i < rowIdsB.size(); ++i) {
                    updateB.setInt(i + 2, (Integer)rowIdsB.get(i));
                }
                updateB.execute();
                updateB.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

