/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.phone;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import nl.minetopiasdb.api.objects.Phone;
import nl.minetopiasdb.api.objects.PhoneContact;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;

public class PhoneManager {
    private static PhoneManager instance;

    public static PhoneManager getInstance() {
        if (instance == null) {
            instance = new PhoneManager();
        }
        return instance;
    }

    public CompletableFuture<Phone> getPhone(int phonenumber) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
                 PreparedStatement ps = conn.prepareStatement("SELECT `CREDIT`, `OWNER` FROM Phones WHERE PHONENUMBER=?");){
                ps.setInt(1, phonenumber);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    double credit = rs.getDouble("CREDIT");
                    UUID owner = UUID.fromString(rs.getString("OWNER"));
                    rs.close();
                    Phone phone = new Phone(phonenumber, credit, owner);
                    return phone;
                }
                rs.close();
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return null;
        });
    }

    public CompletableFuture<Phone> createNewPhone(int phonenumber, UUID owner) {
        return CompletableFuture.supplyAsync(() -> {
            String ignore = TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().Q7xyfcjMTU7Yj0x(ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ) ? "IGNORE" : "OR IGNORE";
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Phone phone;
                block18: {
                    PreparedStatement ps;
                    block16: {
                        Phone phone2;
                        block17: {
                            ps = conn.prepareStatement("INSERT " + ignore + " INTO Phones (PHONENUMBER, CREDIT, OWNER) VALUES (?, ?, ?)");
                            try {
                                ps.setInt(1, phonenumber);
                                ps.setDouble(2, TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().tA7f31NNkhn8WMw(ContainerListenerRepositoryVisitor.rSKhaAXpbi9jhlt));
                                ps.setString(3, owner.toString());
                                if (ps.executeUpdate() == 1) break block16;
                                phone2 = null;
                                if (ps == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (ps != null) {
                                    try {
                                        ps.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            ps.close();
                        }
                        return phone2;
                    }
                    phone = new Phone(phonenumber, TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().tA7f31NNkhn8WMw(ContainerListenerRepositoryVisitor.rSKhaAXpbi9jhlt), owner);
                    if (ps == null) break block18;
                    ps.close();
                }
                return phone;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        });
    }

    public CompletableFuture<List<Phone>> getAllPhones() {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Phone> phones = new ArrayList<Phone>();
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                ResultSet rs = conn.createStatement().executeQuery("SELECT `PHONENUMBER`, `CREDIT`, `OWNER` FROM Phones");
                while (rs.next()) {
                    phones.add(new Phone(rs.getInt("PHONENUMBER"), rs.getDouble("CREDIT"), UUID.fromString(rs.getString("OWNER"))));
                }
                rs.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return phones;
        });
    }

    public CompletableFuture<List<PhoneContact>> getAllContacts(int phonenumber) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<PhoneContact> contacts = new ArrayList<PhoneContact>();
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
                 PreparedStatement ps = conn.prepareStatement("SELECT PC.rowId, `PHONENUMBER_CONTACT`, `OWNER` FROM PhoneContacts PC LEFT JOIN Phones ON Phones.PHONENUMBER = PHONENUMBER_CONTACT WHERE PC.PHONENUMBER=? GROUP BY PC.rowId");){
                ps.setInt(1, phonenumber);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    contacts.add(new PhoneContact(rs.getLong("rowId"), rs.getInt("PHONENUMBER_CONTACT"), UUID.fromString(rs.getString("OWNER"))));
                }
                rs.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return contacts;
        });
    }

    public CompletableFuture<Integer> addContact(int phonenumber, int newContact) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Integer n;
                block14: {
                    PreparedStatement ps = conn.prepareStatement("INSERT INTO PhoneContacts(PHONENUMBER, PHONENUMBER_CONTACT) VALUES (?, ?)");
                    try {
                        ps.setInt(1, phonenumber);
                        ps.setInt(2, newContact);
                        n = ps.executeUpdate();
                        if (ps == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ps.close();
                }
                return n;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0;
            }
        });
    }

    public CompletableFuture<Integer> removeContact(int phonenumber, int contact) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Integer n;
                block14: {
                    PreparedStatement ps = conn.prepareStatement("DELETE FROM PhoneContacts WHERE PHONENUMBER=? AND PHONENUMBER_CONTACT=?");
                    try {
                        ps.setInt(1, phonenumber);
                        ps.setInt(2, contact);
                        n = ps.executeUpdate();
                        if (ps == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ps.close();
                }
                return n;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return 0;
            }
        });
    }

    public int getRandomPhoneNumber() {
        int number = 10000000 + (int)(Math.random() * 9.0E7);
        if (String.valueOf(number).startsWith("06")) {
            return this.getRandomPhoneNumber();
        }
        return number;
    }

    @Deprecated
    public Phone createPhone(int phonenumber, UUID owner) {
        if (!this.isAvailable(phonenumber)) {
            return null;
        }
        try {
            return this.createNewPhone(phonenumber, owner).get();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Deprecated
    public List<Phone> getPhones() {
        try {
            return this.getAllPhones().get();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public List<PhoneContact> getContacts(int phonenumber) {
        try {
            return this.getAllContacts(phonenumber).get();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public boolean isAvailable(int phonenumber) {
        boolean bl;
        block8: {
            Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
            try {
                PreparedStatement ps = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "SELECT rowId FROM Phones WHERE PHONENUMBER=?");
                ps.setInt(1, phonenumber);
                ResultSet rs = ps.executeQuery();
                boolean exists = rs.next();
                rs.close();
                ps.close();
                boolean bl2 = bl = !exists;
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return true;
                }
            }
            conn.close();
        }
        return bl;
    }
}

