/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.mtplaces;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import nl.minetopiasdb.api.mtplaces.abstracts.MTCity;
import nl.minetopiasdb.api.mtplaces.abstracts.MTPlace;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class MTCityManager {
    private static MTCityManager instance;
    private HashMap<String, MTCity> cities = null;

    public static MTCityManager getInstance() {
        if (instance == null) {
            instance = new MTCityManager();
            if (MTCityManager.instance.cities == null) {
                MTCityManager.instance.cities = instance.getCitiesFromDatabase();
            }
        }
        return instance;
    }

    public CompletableFuture<Boolean> addCity(String cityName) {
        MTCity mtc = new MTCity(cityName.toLowerCase(), "&3", "&l" + cityName.toUpperCase(), cityName, 21.64);
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Boolean bl;
                block14: {
                    PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "INSERT INTO `Cities` (cityname, color, title, loadingname, temperature) VALUES (?, ?, ?, ?, ?)");
                    try {
                        statement.setString(1, mtc.getName().toLowerCase());
                        statement.setString(2, mtc.getColor());
                        statement.setString(3, mtc.getTitle());
                        statement.setString(4, mtc.getLoadingName());
                        statement.setDouble(5, mtc.getAverageTemperature());
                        bl = statement.executeUpdate() == 1;
                        if (statement == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return bl;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }).thenApply(success -> {
            if (success.booleanValue()) {
                this.cities.put(cityName.toLowerCase(), mtc);
            }
            return success;
        });
    }

    public CompletableFuture<Boolean> removeCity(String cityName) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Boolean bl;
                block14: {
                    PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "DELETE FROM `Cities` WHERE LOWER(cityname)=?");
                    try {
                        statement.setString(1, cityName.toLowerCase());
                        bl = statement.executeUpdate() == 1;
                        if (statement == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return bl;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }).thenApply(success -> {
            if (success.booleanValue()) {
                this.cities.remove(cityName.toLowerCase());
            }
            return success;
        });
    }

    public Collection<MTCity> getMTCities() {
        return this.cities.values();
    }

    public boolean isSDBEnabled(String cityName) {
        return this.cities.containsKey(cityName.toLowerCase());
    }

    public MTCity getMTCity(String cityName) {
        return this.cities.get(cityName.toLowerCase());
    }

    public MTPlace get(Player player) {
        return this.getCities(player.getLocation()).stream().findFirst().orElse(null);
    }

    public List<MTPlace> getCities(Location location) {
        return Main.getWorldGuard().getRegions(location).stream().filter(protectedRegion -> MTCityManager.getInstance().isSDBEnabled(protectedRegion.getId())).map(protectedRegion -> MTCityManager.getInstance().getMTCity(protectedRegion.getId())).collect(Collectors.toList());
    }

    private HashMap<String, MTCity> getCitiesFromDatabase() {
        HashMap<String, MTCity> cities = new HashMap<String, MTCity>();
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = connection.prepareStatement("SELECT cityname, title, color, loadingname, temperature FROM Cities");
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                String cityname = result.getString("cityname");
                String title = result.getString("title");
                String color = result.getString("color");
                String loadingname = result.getString("loadingname");
                double temperature = result.getDouble("temperature");
                MTCity city = new MTCity(cityname, color, title, loadingname, temperature);
                cities.put(cityname, city);
            }
            result.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return cities;
    }
}

