/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.events.player;

import com.sk89q.worldguard.LocalPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import nl.minetopiasdb.api.API;
import nl.minetopiasdb.api.enums.LevelcheckType;
import nl.minetopiasdb.api.mtplaces.MTWorldManager;
import nl.minetopiasdb.api.playerdata.PlayerManager;
import nl.minetopiasdb.api.playerdata.objects.SDBPlayer;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.ResolverContainerLiteralImporter;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PlayerLevelcheckEvent
extends Event {
    private static final String[] DEFAULT_PREFIXES = new String[]{"Burger", "Zwerver", "Homeless", "Citizen"};
    private static final HandlerList handlers = new HandlerList();
    private final OfflinePlayer player;
    private final LevelcheckType type;
    private int vehicles;

    public PlayerLevelcheckEvent(OfflinePlayer player, int vehicles, LevelcheckType type) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.player = player;
        this.vehicles = vehicles;
        this.type = type;
    }

    public OfflinePlayer getPlayer() {
        return this.player;
    }

    public int getVehicles() {
        return this.vehicles;
    }

    public void setVehicles(int vehicles) {
        this.vehicles = vehicles;
    }

    public LevelcheckType getLevelcheckType() {
        return this.type;
    }

    public int calculateLevel() {
        SDBPlayer sdbpl = PlayerManager.getPlayer(this.player.getUniqueId());
        int points = this.getVehicles() * ResolverContainerLiteralImporter.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("LevelCheck.PointsPerVehicle");
        List defaultPrefixes = Arrays.stream(DEFAULT_PREFIXES).map(String::toLowerCase).collect(Collectors.toList());
        defaultPrefixes.add(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(ContainerListenerRepositoryVisitor.zvlHDbUJDnV24k).toLowerCase());
        if (!defaultPrefixes.contains(sdbpl.getPrefix().toLowerCase())) {
            points += ResolverContainerLiteralImporter.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("LevelCheck.PointsForHavingAJob");
        }
        points += (int)Math.floor(API.getEcon().getBalance(this.player) / 5000.0) * ResolverContainerLiteralImporter.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("LevelCheck.PointsPer5K");
        if (sdbpl.getFitness() != null) {
            int fitness = sdbpl.getFitness().getTotalFitness();
            points += fitness / 20 * ResolverContainerLiteralImporter.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("LevelCheck.PointsPer20Fitness");
        }
        int hours = sdbpl.getTimeDays() * 24 + sdbpl.getTimeHours();
        points += hours * ResolverContainerLiteralImporter.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("LevelCheck.PointsPer1HourOnlineTime");
        try {
            LocalPlayer lPlayer = Main.getWorldGuard().getWorldGuard().wrapOfflinePlayer(this.player);
            points += Bukkit.getWorlds().stream().filter(MTWorldManager.getInstance()::isSDBEnabled).flatMap(world -> {
                try {
                    return Main.getWorldGuard().getRegionManager(world).getRegions().values().stream();
                }
                catch (Exception e) {
                    return new ArrayList().stream();
                }
            }).filter(region -> region.isOwner(lPlayer)).map(nl.minetopiasdb.plugin.utils.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel::httHooAopOc0CwK).mapToInt(Integer::intValue).sum();
        }
        catch (Exception lPlayer) {
            // empty catch block
        }
        int level = 1 + points / ResolverContainerLiteralImporter.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("LevelCheck.PointsNeededForLevelUp");
        if (level > ResolverContainerLiteralImporter.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("LevelCheck.MaxLevel")) {
            level = ResolverContainerLiteralImporter.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("LevelCheck.MaxLevel");
        }
        return level;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

