/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.phone;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import nl.minetopiasdb.api.objects.Phone;
import nl.minetopiasdb.api.objects.PhoneContact;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;

public class PhoneManager {
    private static PhoneManager instance;

    public static PhoneManager getInstance() {
        if (instance == null) {
            instance = new PhoneManager();
        }
        return instance;
    }

    public List<Phone> getPhones() {
        ArrayList<Phone> phones = new ArrayList<Phone>();
        try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            ResultSet rs = conn.createStatement().executeQuery("SELECT `PHONENUMBER`, `CREDIT`, `OWNER` FROM Phones");
            while (rs.next()) {
                phones.add(new Phone(rs.getInt("PHONENUMBER"), rs.getDouble("CREDIT"), UUID.fromString(rs.getString("OWNER"))));
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return phones;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Phone getPhone(int phonenumber) {
        try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement ps = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "SELECT `CREDIT`, `OWNER` FROM Phones WHERE PHONENUMBER=?");
            ps.setInt(1, phonenumber);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                double credit = rs.getDouble("CREDIT");
                UUID owner = UUID.fromString(rs.getString("OWNER"));
                rs.close();
                Phone phone = new Phone(phonenumber, credit, owner);
                return phone;
            }
            rs.close();
            ps.close();
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public Phone createPhone(int phonenumber, UUID owner) {
        Phone phone;
        block9: {
            if (!this.isAvailable(phonenumber)) {
                return null;
            }
            Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
            try {
                PreparedStatement ps = conn.prepareStatement("INSERT INTO Phones (PHONENUMBER, CREDIT, OWNER) VALUES (?, ?, ?)");
                ps.setInt(1, phonenumber);
                ps.setDouble(2, TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().tA7f31NNkhn8WMw(ContainerListenerRepositoryVisitor.FAOuZodqmvBPwjq));
                ps.setString(3, owner.toString());
                ps.execute();
                phone = new Phone(phonenumber, TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().tA7f31NNkhn8WMw(ContainerListenerRepositoryVisitor.FAOuZodqmvBPwjq), owner);
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            conn.close();
        }
        return phone;
    }

    public List<PhoneContact> getContacts(int phonenumber) {
        ArrayList<PhoneContact> contacts = new ArrayList<PhoneContact>();
        try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement ps = conn.prepareStatement("SELECT PC.rowId, `PHONENUMBER_CONTACT`, `OWNER` FROM PhoneContacts PC LEFT JOIN Phones ON Phones.PHONENUMBER = PHONENUMBER_CONTACT WHERE PC.PHONENUMBER=? GROUP BY PC.rowId");
            ps.setInt(1, phonenumber);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                contacts.add(new PhoneContact(rs.getLong("rowId"), rs.getInt("PHONENUMBER_CONTACT"), UUID.fromString(rs.getString("OWNER"))));
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return contacts;
    }

    public void addContact(int phonenumber, int newContact) {
        try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement ps = conn.prepareStatement("INSERT INTO PhoneContacts(PHONENUMBER, PHONENUMBER_CONTACT) VALUES (?, ?)");
            ps.setInt(1, phonenumber);
            ps.setInt(2, newContact);
            ps.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void removeContact(int phonenumber, int contact) {
        try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement ps = conn.prepareStatement("DELETE FROM PhoneContacts WHERE PHONENUMBER=? AND PHONENUMBER_CONTACT=?");
            ps.setInt(1, phonenumber);
            ps.setInt(2, contact);
            ps.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isAvailable(int phonenumber) {
        boolean bl;
        block8: {
            Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
            try {
                PreparedStatement ps = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "SELECT rowId FROM Phones WHERE PHONENUMBER=?");
                ps.setInt(1, phonenumber);
                ResultSet rs = ps.executeQuery();
                boolean exists = rs.next();
                rs.close();
                ps.close();
                boolean bl2 = bl = !exists;
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return true;
                }
            }
            conn.close();
        }
        return bl;
    }

    public int getRandomPhoneNumber() {
        int number = 10000000 + (int)(Math.random() * 9.0E7);
        if (String.valueOf(number).startsWith("06")) {
            return this.getRandomPhoneNumber();
        }
        return number;
    }
}

