/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.election;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import nl.mrwouter.channelmanager.MessageListener;
import org.apache.commons.lang.Validate;

public class ElectionManager
implements MessageListener {
    private static ElectionManager instance;
    private final String GLOBALSTORAGE_KEY = "electionStarted";
    private List<UUID> awaitingVoteCompletion = new ArrayList<UUID>();
    private List<UUID> alreadyVotedCache = new ArrayList<UUID>();
    private HashMap<UUID, String> candidateCache = new HashMap();

    public static ElectionManager getInstance() {
        if (instance == null) {
            instance = new ElectionManager();
            instance.fillAlreadyVotedCache();
            instance.fillCandidateCache();
        }
        return instance;
    }

    public CompletableFuture<Boolean> isStarted() {
        return ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("electionStarted").thenApply(c2 -> c2 != null && c2.equals("1"));
    }

    public CompletableFuture<Boolean> start() {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Statement statement = conn.createStatement();
                statement.execute("DELETE FROM ElectionVotes");
                statement.execute("DELETE FROM ElectionCandidates");
                statement.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                Boolean bl = false;
                return bl;
            }
            finally {
                this.alreadyVotedCache.clear();
                this.candidateCache.clear();
            }
            ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("electionStarted", "1");
            return true;
        });
    }

    public CompletableFuture<Void> end() {
        return CompletableFuture.runAsync(() -> ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("electionStarted", "0"));
    }

    public CompletableFuture<HashMap<UUID, Integer>> getVotes() {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                LinkedHashMap<UUID, Integer> linkedHashMap;
                block15: {
                    Statement statement = conn.createStatement();
                    try {
                        ResultSet rs = statement.executeQuery("SELECT COUNT(voter_uuid) AS `votes`, EC.candidate_uuid FROM ElectionCandidates EC LEFT JOIN ElectionVotes EV ON EC.candidate_uuid = EV.candidate_uuid GROUP BY EC.candidate_uuid ORDER BY votes DESC");
                        LinkedHashMap<UUID, Integer> votes = new LinkedHashMap<UUID, Integer>();
                        while (rs.next()) {
                            votes.put(UUID.fromString(rs.getString("candidate_uuid")), rs.getInt("votes"));
                        }
                        rs.close();
                        linkedHashMap = votes;
                        if (statement == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return linkedHashMap;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                return null;
            }
        });
    }

    public boolean hasVoted(UUID uuid) {
        return this.alreadyVotedCache.contains(uuid);
    }

    public CompletableFuture<Boolean> vote(UUID voter, UUID candidate) {
        this.awaitingVoteCompletion.add(voter);
        return CompletableFuture.supplyAsync(() -> {
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Boolean bl;
                block14: {
                    PreparedStatement ps = conn.prepareStatement("INSERT INTO ElectionVotes VALUES (?, ?)");
                    try {
                        ps.setString(1, voter.toString());
                        ps.setString(2, candidate.toString());
                        bl = ps.executeUpdate() == 1;
                        if (ps == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ps.close();
                }
                return bl;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                return false;
            }
        }).whenComplete((input, exception) -> {
            this.awaitingVoteCompletion.remove(voter);
            this.alreadyVotedCache.add(candidate);
            if (Main.getChannelManager() != null) {
                Main.getChannelManager().send("election", "vote", (Map)ImmutableMap.of((Object)"voter", (Object)voter.toString()));
            }
        });
    }

    public HashMap<UUID, String> getCandidates() {
        return (HashMap)this.candidateCache.clone();
    }

    public CompletableFuture<Boolean> addCandidate(UUID uuid, String extraInfo) {
        Validate.isTrue((extraInfo.length() <= 255 ? 1 : 0) != 0, (String)"extraInfo field exceeds maximum length of 255 characters");
        return CompletableFuture.supplyAsync(() -> {
            try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                Boolean bl;
                block15: {
                    PreparedStatement ps = conn.prepareStatement("INSERT INTO ElectionCandidates VALUES (?, ?)");
                    try {
                        ps.setString(1, uuid.toString());
                        ps.setString(2, extraInfo);
                        this.candidateCache.put(uuid, extraInfo);
                        if (Main.getChannelManager() != null) {
                            Main.getChannelManager().send("election", "addcandidate", (Map)ImmutableMap.of((Object)"candidate", (Object)uuid.toString(), (Object)"extraInfo", (Object)extraInfo));
                        }
                        bl = ps.executeUpdate() == 1;
                        if (ps == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ps.close();
                }
                return bl;
            }
            catch (SQLException sQLException) {
                return false;
            }
        });
    }

    public CompletableFuture<Boolean> removeCandidate(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private void fillAlreadyVotedCache() {
        this.alreadyVotedCache.clear();
        try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
             Statement statement = conn.createStatement();){
            ResultSet rs = statement.executeQuery("SELECT voter_uuid from ElectionVotes");
            while (rs.next()) {
                this.alreadyVotedCache.add(UUID.fromString(rs.getString("voter_uuid")));
            }
            rs.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public void fillCandidateCache() {
        this.candidateCache.clear();
        try (Connection conn = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
             Statement statement = conn.createStatement();){
            ResultSet rs = statement.executeQuery("SELECT * FROM ElectionCandidates");
            while (rs.next()) {
                this.candidateCache.put(UUID.fromString(rs.getString("candidate_uuid")), rs.getString("extra_info"));
            }
            rs.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public boolean onMessageReceive(String channel, String subChannel, Map<String, String> data) {
        if (subChannel.equals("vote")) {
            UUID voter = UUID.fromString(data.get("voter"));
            if (!this.alreadyVotedCache.contains(voter)) {
                this.alreadyVotedCache.add(voter);
            }
            return true;
        }
        if (subChannel.equals("addcandidate")) {
            UUID candidate = UUID.fromString(data.get("candidate"));
            String extraInfo = data.get("extraInfo");
            this.candidateCache.put(candidate, extraInfo);
            return true;
        }
        if (subChannel.equalsIgnoreCase("removecandidate")) {
            UUID candidate = UUID.fromString(data.get("candidate"));
            this.candidateCache.remove(candidate);
            return true;
        }
        return false;
    }
}

