/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import nl.minetopiasdb.api.events.player.CriminalRecordEntryAddedEvent;
import nl.minetopiasdb.api.events.player.CriminalRecordEntryDeletedEvent;
import nl.minetopiasdb.api.objects.CriminalActivity;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CriminalRecordManager {
    private static CriminalRecordManager instance;

    public static CriminalRecordManager getInstance() {
        if (instance == null) {
            instance = new CriminalRecordManager();
        }
        return instance;
    }

    public List<CriminalActivity> getCriminalActivities(UUID uuid) {
        ArrayList<CriminalActivity> activities = new ArrayList<CriminalActivity>();
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = connection.prepareStatement("SELECT `rowId`, `description` FROM CriminalRecords WHERE UUID=?");
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                activities.add(new CriminalActivity(rs.getInt("rowId"), rs.getString("description")));
            }
            rs.close();
            statement.close();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return activities;
    }

    public CompletableFuture<Void> addEntry(UUID uuid, String description) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = connection.prepareStatement("INSERT INTO CriminalRecords (UUID, description) VALUES (?, ?)");
                statement.setString(1, uuid.toString());
                statement.setString(2, description);
                statement.execute();
                statement.close();
                CriminalRecordEntryAddedEvent event = new CriminalRecordEntryAddedEvent(uuid, description);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            return null;
        });
    }

    public CompletableFuture<Void> deleteEntry(UUID uuid, String description) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = connection.prepareStatement("DELETE FROM CriminalRecords WHERE UUID=? AND description=?");
                statement.setString(1, uuid.toString());
                statement.setString(2, description);
                statement.execute();
                statement.close();
                CriminalRecordEntryDeletedEvent event = new CriminalRecordEntryDeletedEvent(uuid);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            return null;
        });
    }

    public CompletableFuture<Void> deleteEntry(UUID uuid, int id) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = connection.prepareStatement("DELETE FROM CriminalRecords WHERE UUID=? AND rowId=?");
                statement.setString(1, uuid.toString());
                statement.setInt(2, id);
                statement.execute();
                statement.close();
                CriminalRecordEntryDeletedEvent event = new CriminalRecordEntryDeletedEvent(uuid);
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            return null;
        });
    }

    @Deprecated
    public void addCriminalActivity(UUID uuid, String description) {
        this.addEntry(uuid, description);
    }

    @Deprecated
    public void deleteCriminalActivity(UUID uuid, String description) {
        this.deleteEntry(uuid, description);
    }

    @Deprecated
    public void deleteCriminalActivity(UUID uuid, int id) {
        this.deleteEntry(uuid, id);
    }
}

