/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.playerdata;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import nl.minetopiasdb.api.events.player.PlayerSwapEvent;
import nl.minetopiasdb.api.playerdata.fitness.FitnessManager;
import nl.minetopiasdb.api.playerdata.fitness.boost.FitnessBoost;
import nl.minetopiasdb.api.playerdata.fitness.boost.FitnessBoostManager;
import nl.minetopiasdb.api.playerdata.fitness.objects.Fitness;
import nl.minetopiasdb.api.playerdata.objects.OfflineSDBPlayer;
import nl.minetopiasdb.api.playerdata.objects.OnlineSDBPlayer;
import nl.minetopiasdb.api.playerdata.objects.SDBPlayer;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class PlayerManager {
    private ConcurrentHashMap<UUID, OnlineSDBPlayer> sdbplayers = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, OfflineSDBPlayer> cachedofflineplayers = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, List<TestsServiceBridgeMappingModel>> changes = new ConcurrentHashMap();
    private ArrayList<UUID> dataLoading = new ArrayList();
    private static PlayerManager instance;

    public static PlayerManager getInstance() {
        if (instance == null) {
            instance = new PlayerManager();
        }
        return instance;
    }

    public Collection<OnlineSDBPlayer> getOnlinePlayers() {
        return this.sdbplayers.values();
    }

    public static SDBPlayer getPlayer(UUID uuid) {
        return PlayerManager.getInstance().getPlayer0(uuid);
    }

    public static OnlineSDBPlayer getOnlinePlayer(UUID uuid) {
        return PlayerManager.getInstance().getOnlinePlayer0(uuid);
    }

    public static OfflineSDBPlayer getOfflinePlayer(UUID uuid) {
        return PlayerManager.getInstance().getOfflinePlayer0(uuid);
    }

    private OnlineSDBPlayer getOnlinePlayer0(UUID uuid) {
        return this.sdbplayers.get(uuid);
    }

    private SDBPlayer getPlayer0(UUID uuid) {
        if (this.sdbplayers.containsKey(uuid)) {
            return this.getOnlinePlayer0(uuid);
        }
        return this.getOfflinePlayer0(uuid);
    }

    private OfflineSDBPlayer getOfflinePlayer0(UUID uuid) {
        if (this.cachedofflineplayers.contains(uuid)) {
            return this.cachedofflineplayers.get(uuid);
        }
        OfflineSDBPlayer target = new OfflineSDBPlayer(uuid);
        FitnessManager.getInstance().loadOfflinePlayer(target);
        this.cachedofflineplayers.remove(uuid);
        this.cachedofflineplayers.put(uuid, target);
        return target;
    }

    public boolean isInDatabase(UUID uuid) {
        boolean bl;
        block8: {
            Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
            try {
                PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT rowId FROM Players WHERE UUID=?");
                statement.setString(1, uuid.toString());
                ResultSet result = statement.executeQuery();
                boolean hasNext = result.next();
                result.close();
                statement.close();
                bl = hasNext;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    public void addDefaults(UUID uuid) {
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            String values = "";
            String questionmarks = "";
            ArrayList<Object> defaultValue = new ArrayList<Object>();
            for (ContainerListenerRepositoryVisitor containerListenerRepositoryVisitor : ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ()) {
                values = values + containerListenerRepositoryVisitor.httHooAopOc0CwK() + ",";
                questionmarks = questionmarks + "?,";
                defaultValue.add(containerListenerRepositoryVisitor.tA7f31NNkhn8WMw());
            }
            values = values.substring(0, values.length() - 1);
            questionmarks = questionmarks.substring(0, questionmarks.length() - 1);
            PreparedStatement statement = connection.prepareStatement("INSERT INTO Players (" + values + ") VALUES (" + questionmarks + ")");
            int parameterIndex = 1;
            for (Object e : defaultValue) {
                if (e instanceof Double) {
                    statement.setDouble(parameterIndex, (Double)e);
                } else if (e instanceof String) {
                    statement.setString(parameterIndex, ((String)e).replace("[uuid]", uuid.toString()));
                } else if (e instanceof Integer) {
                    statement.setInt(parameterIndex, (Integer)e);
                } else if (e instanceof Boolean) {
                    statement.setInt(parameterIndex, (Boolean)e != false ? 1 : 0);
                } else if (e == null) {
                    statement.setNull(parameterIndex, 12);
                }
                ++parameterIndex;
            }
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void loadPlayer(UUID uuid) {
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT `prefix`, `prefixcolor`, `selectedchatcolor`, `citycolor`, `levelcolor`, `level`, `chatspy`, `commandspy`, `staffchat`, `graycoins`, `goldshards`, `grayshards`, `luckyshards`, `timeSeconds`, `timeMinutes`, `timeHours`, `timeDays`, `deathbanTime`, `handcuffed`, `handcuffedBy`, `fitnessreset` FROM `Players` WHERE UUID=?");
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                String prefix = rs.getString("prefix");
                String prefixcolor = rs.getString("prefixcolor");
                String chatcolor = rs.getString("selectedchatcolor");
                String citycolor = rs.getString("citycolor");
                String levelcolor = rs.getString("levelcolor");
                int level = rs.getInt("level");
                boolean chatspy = rs.getInt("chatspy") != 0;
                boolean fitnessreset = rs.getInt("fitnessreset") != 0;
                boolean commandspy = rs.getInt("commandspy") != 0;
                boolean staffchat = rs.getInt("staffchat") != 0;
                int graycoins = rs.getInt("graycoins");
                double goldshards = rs.getDouble("goldshards");
                double grayshards = rs.getDouble("grayshards");
                double luckyshards = rs.getDouble("luckyshards");
                int timeseconds = rs.getInt("timeSeconds");
                int timeminutes = rs.getInt("timeMinutes");
                int timehours = rs.getInt("timeHours");
                int timedays = rs.getInt("timeDays");
                boolean handcuffed = rs.getInt("handcuffed") != 0;
                UUID handcuffedBy = rs.getString("handcuffedBy") == null ? null : UUID.fromString(rs.getString("handcuffedBy"));
                long deathbanTime = rs.getLong("deathbanTime");
                OnlineSDBPlayer player = new OnlineSDBPlayer(uuid, prefix, prefixcolor, chatcolor, citycolor, levelcolor, level, chatspy, commandspy, staffchat, graycoins, goldshards, grayshards, luckyshards, null, timeseconds, timeminutes, timehours, timedays, deathbanTime, handcuffed, handcuffedBy, fitnessreset);
                this.sdbplayers.put(uuid, player);
            }
            rs.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void quit(UUID uuid) {
        this.sdbplayers.remove(uuid);
    }

    public List<UUID> getChangedUsers() {
        return Collections.list(this.changes.keys());
    }

    public void manageSet(UUID who, String path, Object value) {
        TestsServiceBridgeMappingModel data = new TestsServiceBridgeMappingModel(path, value);
        ArrayList<TestsServiceBridgeMappingModel> playerChanges = new ArrayList<TestsServiceBridgeMappingModel>();
        if (this.changes.containsKey(who)) {
            playerChanges.addAll((Collection)this.changes.get(who));
            for (TestsServiceBridgeMappingModel loopedData : new ArrayList(playerChanges)) {
                if (!loopedData.wkMvHiTHLyqFIhJ().equalsIgnoreCase(path)) continue;
                playerChanges.remove(loopedData);
            }
        }
        playerChanges.add(data);
        this.changes.remove(who);
        this.changes.put(who, playerChanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushSetsToDatabase(UUID uuid) {
        if (this.changes.get(uuid) == null) {
            return;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String setVal = "";
        for (TestsServiceBridgeMappingModel data : this.changes.get(uuid)) {
            setVal = setVal + "`" + data.wkMvHiTHLyqFIhJ() + "`=?,";
            values.add(data.httHooAopOc0CwK());
        }
        setVal = setVal.substring(0, setVal.length() - 1);
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = connection.prepareStatement("UPDATE Players SET " + setVal + " WHERE `UUID`=?");
            int parameterIndex = 1;
            for (Object e : values) {
                if (e instanceof Double) {
                    statement.setDouble(parameterIndex, (Double)e);
                } else if (e instanceof String) {
                    statement.setString(parameterIndex, (String)e);
                } else if (e instanceof Integer) {
                    statement.setInt(parameterIndex, (Integer)e);
                } else if (e instanceof Boolean) {
                    statement.setInt(parameterIndex, (Boolean)e != false ? 1 : 0);
                } else if (e instanceof Long) {
                    statement.setLong(parameterIndex, (Long)e);
                } else if (e == null) {
                    statement.setNull(parameterIndex, 12);
                }
                ++parameterIndex;
            }
            statement.setString(parameterIndex, uuid.toString());
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.changes.remove(uuid);
        }
    }

    public boolean isLoading(UUID uuid) {
        return this.dataLoading.contains(uuid);
    }

    public void setLoading(UUID uuid) {
        this.dataLoading.add(uuid);
    }

    public void stopLoading(UUID uuid) {
        this.dataLoading.remove(uuid);
    }

    public boolean isOfflineCached(UUID uuid) {
        return this.cachedofflineplayers.containsKey(uuid);
    }

    public void removeFromOfflineCache(UUID uuid) {
        this.cachedofflineplayers.remove(uuid);
    }

    public void clearOfflineCache() {
        this.cachedofflineplayers.clear();
    }

    public void removeFromChangeCache(UUID uuid) {
        this.changes.remove(uuid);
    }

    public void swap(UUID source, UUID target) {
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            int sourceBoosts = FitnessBoostManager.getInstance().getFitnessBoosts(false).stream().filter(boost -> boost.getUUID().equals(source)).mapToInt(FitnessBoost::getFitness).sum();
            int targetBoosts = FitnessBoostManager.getInstance().getFitnessBoosts(false).stream().filter(boost -> boost.getUUID().equals(target)).mapToInt(FitnessBoost::getFitness).sum();
            SDBPlayer sourcePlayer = PlayerManager.getPlayer(source);
            SDBPlayer targetPlayer = PlayerManager.getPlayer(target);
            Fitness sourcePlayerFit = sourcePlayer.getFitness();
            sourcePlayerFit.setTotalFitness(sourcePlayerFit.getTotalFitness() - sourceBoosts);
            Fitness targetPlayerFit = targetPlayer.getFitness();
            targetPlayerFit.setTotalFitness(targetPlayerFit.getTotalFitness() - targetBoosts);
            if (sourcePlayer instanceof OnlineSDBPlayer) {
                FitnessManager.getInstance().pushSetsToDatabase(sourcePlayer.getUUID(), ((OnlineSDBPlayer)sourcePlayer).getFitness().getChanges());
            }
            if (targetPlayer instanceof OnlineSDBPlayer) {
                FitnessManager.getInstance().pushSetsToDatabase(targetPlayer.getUUID(), ((OnlineSDBPlayer)targetPlayer).getFitness().getChanges());
            }
            int rowIdTarget = this.getRowId(target, "Players", connection);
            int rowIdSource = this.getRowId(source, "Players", connection);
            this.changeUUID(target, "Players", rowIdSource, connection);
            this.changeUUID(source, "Players", rowIdTarget, connection);
            int fitRowIdTarget = this.getRowId(target, "Fitness", connection);
            int fitRowIdSource = this.getRowId(source, "Fitness", connection);
            this.changeUUID(target, "Fitness", fitRowIdSource, connection);
            this.changeUUID(source, "Fitness", fitRowIdTarget, connection);
            if (Main.getChannelManager() != null) {
                Main.getChannelManager().send("player", "clearcache", (Map)ImmutableMap.of((Object)"uuid", (Object)source.toString()));
                Main.getChannelManager().send("player", "clearcache", (Map)ImmutableMap.of((Object)"uuid", (Object)target.toString()));
            }
            PlayerManager.getInstance().removeFromOfflineCache(source);
            PlayerManager.getInstance().quit(source);
            PlayerManager.getInstance().removeFromOfflineCache(target);
            PlayerManager.getInstance().quit(target);
            if (Bukkit.getPlayer((UUID)source) != null) {
                PlayerManager.getInstance().loadPlayer(source);
                FitnessManager.getInstance().loadOnlinePlayer(PlayerManager.getOnlinePlayer(source));
            }
            if (Bukkit.getPlayer((UUID)target) != null) {
                PlayerManager.getInstance().loadPlayer(target);
                FitnessManager.getInstance().loadOnlinePlayer(PlayerManager.getOnlinePlayer(target));
            }
            PlayerSwapEvent event = new PlayerSwapEvent(source, target);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private int getRowId(UUID uuid, String table, Connection connection) throws SQLException {
        int rowId = -1;
        PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT rowId FROM `" + table + "` WHERE `UUID`=?");
        statement.setString(1, uuid.toString());
        ResultSet rs = statement.executeQuery();
        if (rs.next()) {
            rowId = rs.getInt("rowId");
        }
        rs.close();
        statement.close();
        return rowId;
    }

    private void changeUUID(UUID newUuid, String table, int rowId, Connection connection) throws SQLException {
        PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "UPDATE `" + table + "` SET `UUID`=? WHERE `rowId`=?");
        statement.setString(1, newUuid.toString());
        statement.setInt(2, rowId);
        statement.execute();
        statement.close();
    }
}

