/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.banking;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import nl.minetopiasdb.api.banking.Bankaccount;
import nl.minetopiasdb.api.enums.BankAccountType;
import nl.minetopiasdb.api.enums.BankPermission;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;

public class BankUtils {
    private static BankUtils instance;
    private static HashMap<Integer, Bankaccount> cachedAccounts;
    private DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
    private DecimalFormat decimalFormatNoComma = new DecimalFormat("#,###");

    public static BankUtils getInstance() {
        if (instance == null) {
            instance = new BankUtils();
        }
        return instance;
    }

    public Bankaccount getBankAccount(int id) {
        return cachedAccounts.get(id);
    }

    public List<Bankaccount> getAccounts(BankAccountType ... accountTypes) {
        return cachedAccounts.values().stream().filter(acc -> Arrays.asList(accountTypes).contains((Object)acc.getType())).collect(Collectors.toList());
    }

    public List<Bankaccount> getAccounts(UUID uuid) {
        return cachedAccounts.values().stream().filter(account -> account.getAuthorisedUsers().contains(uuid)).collect(Collectors.toList());
    }

    public List<Bankaccount> getAccounts(UUID uuid, BankAccountType ... accountTypes) {
        return this.getAccounts(uuid).stream().filter(acc -> Arrays.asList(accountTypes).contains((Object)acc.getType())).collect(Collectors.toList());
    }

    public void pullCache() {
        cachedAccounts.clear();
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT * FROM Bankaccount");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int id = rs.getInt("bankId");
                double balance = rs.getDouble("balance");
                String typeString = rs.getString("bankAccountType");
                String name = rs.getString("bankAccountName");
                boolean frozen = rs.getBoolean("frozen");
                BankAccountType type = BankAccountType.valueOf(typeString);
                Bankaccount acc = new Bankaccount(id, type, balance, name, frozen, new HashMap<UUID, BankPermission>());
                cachedAccounts.put(id, acc);
            }
            rs.close();
            statement.close();
            PreparedStatement userStatement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT * FROM BankaccountUsers");
            ResultSet userRs = userStatement.executeQuery();
            while (userRs.next()) {
                int id = userRs.getInt("bankId");
                String uuidStr = userRs.getString("UUID");
                UUID uuid = UUID.fromString(uuidStr);
                BankPermission permission = BankPermission.valueOf(userRs.getString("permission"));
                if (cachedAccounts.get(id) == null) continue;
                cachedAccounts.get(id).addUserSilent(uuid, permission);
            }
            userRs.close();
            userStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void toDatabase() {
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            for (Bankaccount bank : cachedAccounts.values()) {
                PreparedStatement statement = connection.prepareStatement("UPDATE `Bankaccount` SET `balance`=?, `bankAccountName`=?, `frozen`=? WHERE `bankId`=?");
                statement.setDouble(1, bank.getBalance());
                statement.setString(2, bank.getName());
                statement.setBoolean(3, bank.isFrozen());
                statement.setInt(4, bank.getId());
                statement.execute();
                statement.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void clearCache() {
        cachedAccounts.clear();
    }

    public String format(double number) {
        if (TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("MoneyFormatting.HasDecimal")) {
            return this.decimalFormat.format(number).replace(",", "tmp").replace(".", ",").replace("tmp", ".");
        }
        return this.decimalFormatNoComma.format(number).replace(",", ".");
    }

    public int create(BankAccountType type) throws IllegalArgumentException {
        int n;
        block11: {
            if (type == BankAccountType.PERSONAL) {
                throw new IllegalArgumentException("Can't create a personal bank account!");
            }
            Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
            try {
                PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "INSERT INTO `Bankaccount`(`balance`, `bankAccountType`, `bankAccountName`, `frozen`) VALUES (?, ?, ?, ?)", 1);
                statement.setDouble(1, 0.0);
                statement.setString(2, type.getTypeName());
                statement.setString(3, "Loading..");
                statement.setBoolean(4, false);
                statement.executeUpdate();
                ResultSet rs = statement.getGeneratedKeys();
                int last_inserted_id = -1;
                if (rs.next()) {
                    last_inserted_id = rs.getInt(1);
                    PreparedStatement updateName = connection.prepareStatement("UPDATE `Bankaccount` SET `bankAccountName`=? WHERE bankId=?");
                    updateName.setString(1, "&fID: " + last_inserted_id);
                    updateName.setInt(2, last_inserted_id);
                    updateName.execute();
                    updateName.close();
                }
                statement.close();
                rs.close();
                if (Main.getChannelManager() != null) {
                    Main.getChannelManager().send("bank", "create", (Map)ImmutableMap.of((Object)"id", (Object)("" + last_inserted_id), (Object)"type", (Object)type.name()));
                }
                this.silentlyCreateBankaccount(last_inserted_id, type);
                n = last_inserted_id;
                if (connection == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            connection.close();
        }
        return n;
    }

    public void delete(int id) {
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "DELETE FROM `Bankaccount` WHERE bankId=?");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            PreparedStatement userStatement = connection.prepareStatement("DELETE FROM `BankaccountUsers` WHERE bankId=?");
            userStatement.setInt(1, id);
            userStatement.execute();
            userStatement.close();
            cachedAccounts.remove(id);
            if (Main.getChannelManager() != null) {
                Main.getChannelManager().send("bank", "delete", (Map)ImmutableMap.of((Object)"id", (Object)("" + id)));
            }
            this.silentlyDeleteBankaccount(id);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void silentlyCreateBankaccount(int id, BankAccountType type) {
        cachedAccounts.put(id, new Bankaccount(id, type, 0.0, "&fID: " + id, false, new HashMap<UUID, BankPermission>()));
    }

    public void silentlyDeleteBankaccount(int id) {
        cachedAccounts.remove(id);
    }

    public int getSlots(int accounts) {
        if (accounts <= 18) {
            return 18;
        }
        if (accounts > 45) {
            return 54;
        }
        if (accounts > 36) {
            return 45;
        }
        if (accounts > 27) {
            return 36;
        }
        if (accounts > 18) {
            return 27;
        }
        return 18;
    }

    static {
        cachedAccounts = new HashMap();
    }
}

