/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import nl.minetopiasdb.api.events.player.CriminalRecordEntryAddedEvent;
import nl.minetopiasdb.api.events.player.CriminalRecordEntryDeletedEvent;
import nl.minetopiasdb.api.objects.CriminalActivity;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;

public class CriminalRecordManager {
    private static CriminalRecordManager instance;

    public static CriminalRecordManager getInstance() {
        if (instance == null) {
            instance = new CriminalRecordManager();
        }
        return instance;
    }

    public List<CriminalActivity> getCriminalActivities(UUID uuid) {
        ArrayList<CriminalActivity> activities = new ArrayList<CriminalActivity>();
        try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = connection.prepareStatement("SELECT `rowId`, `description` FROM CriminalRecords WHERE UUID=?");
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                activities.add(new CriminalActivity(rs.getInt("rowId"), rs.getString("description")));
            }
            rs.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return activities;
    }

    public CompletableFuture<Integer> addEntry(UUID uuid, String description) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = connection.prepareStatement("INSERT INTO CriminalRecords (UUID, description) VALUES (?, ?)", 1);
                statement.setString(1, uuid.toString());
                statement.setString(2, description);
                statement.execute();
                statement.close();
                try (ResultSet rs = statement.getGeneratedKeys();){
                    if (!rs.next()) return null;
                    int lastInsertedId = rs.getInt(1);
                    CriminalRecordEntryAddedEvent event = new CriminalRecordEntryAddedEvent(uuid, lastInsertedId, description);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    Integer n = lastInsertedId;
                    return n;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    public CompletableFuture<Boolean> deleteEntry(UUID uuid, int id) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
                 PreparedStatement statement = connection.prepareStatement("DELETE FROM CriminalRecords WHERE UUID=? AND rowId=?");){
                statement.setString(1, uuid.toString());
                statement.setInt(2, id);
                int rows = statement.executeUpdate();
                if (rows <= 0) return false;
                CriminalRecordEntryDeletedEvent event = new CriminalRecordEntryDeletedEvent(uuid, id);
                Bukkit.getPluginManager().callEvent((Event)event);
                Boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return false;
        });
    }

    @Deprecated
    public CompletableFuture<Void> deleteEntry(UUID uuid, String description) {
        return CompletableFuture.supplyAsync(() -> {
            try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
                 PreparedStatement statement = connection.prepareStatement("SELECT rowId FROM CriminalRecords WHERE UUID=? AND description=? LIMIT 1");){
                statement.setString(1, uuid.toString());
                statement.setString(2, description);
                try (ResultSet rs = statement.executeQuery();){
                    if (rs.next()) {
                        int id = rs.getInt("rowId");
                        this.deleteEntry(uuid, id);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    @Deprecated
    public void addCriminalActivity(UUID uuid, String description) {
        this.addEntry(uuid, description);
    }

    @Deprecated
    public void deleteCriminalActivity(UUID uuid, String description) {
        this.deleteEntry(uuid, description);
    }

    @Deprecated
    public void deleteCriminalActivity(UUID uuid, int id) {
        this.deleteEntry(uuid, id);
    }
}

