/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.banking;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.minetopiasdb.api.enums.BankAccountType;
import nl.minetopiasdb.api.enums.BankPermission;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.PrinterAnnotationTestsPoolTask;
import org.bukkit.Bukkit;

public class Bankaccount {
    private int id;
    private String name;
    private BankAccountType type;
    private double balance;
    private boolean frozen;
    private HashMap<UUID, BankPermission> users;

    public Bankaccount(int id, BankAccountType type, double balance, String name, boolean frozen, HashMap<UUID, BankPermission> users) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.balance = balance;
        this.frozen = frozen;
        this.users = users;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BankAccountType getType() {
        return this.type;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double newBalance) {
        double balanceChange = newBalance - this.balance;
        this.balance = newBalance;
        if (Main.getChannelManager() != null) {
            Main.getChannelManager().send("bank", "balance", (Map)ImmutableMap.of((Object)"id", (Object)("" + this.getId()), (Object)"balanceChange", (Object)("" + balanceChange)));
        }
    }

    public void setBalanceSilent(double newBalance) {
        this.balance = newBalance;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
        if (Main.getChannelManager() != null) {
            Main.getChannelManager().send("bank", "freeze", (Map)ImmutableMap.of((Object)"id", (Object)("" + this.getId()), (Object)"freeze", (Object)("" + frozen)));
        }
    }

    public void setFrozenSilent(boolean frozen) {
        this.frozen = frozen;
    }

    public List<UUID> getAuthorisedUsers() {
        return Collections.unmodifiableList(new ArrayList<UUID>(this.users.keySet()));
    }

    public Map<UUID, BankPermission> getUsers() {
        return Collections.unmodifiableMap(this.users);
    }

    public boolean hasPermission(UUID uuid, BankPermission permission) {
        if (!this.getUsers().containsKey(uuid)) {
            return false;
        }
        BankPermission userPerm = this.getUsers().get(uuid);
        return userPerm == BankPermission.ADMIN || userPerm == permission;
    }

    public void setName(String name) {
        this.name = name;
        if (Main.getChannelManager() != null) {
            Main.getChannelManager().send("bank", "rename", (Map)ImmutableMap.of((Object)"id", (Object)("" + this.getId()), (Object)"name", (Object)name));
        }
    }

    public void setNameSilent(String name) {
        this.name = name;
    }

    public void addUser(final UUID uuid, final BankPermission permission) {
        this.addUserSilent(uuid, permission);
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                    PreparedStatement userStatement = connection.prepareStatement("INSERT INTO BankaccountUsers (bankId, UUID, permission) VALUES (?, ?, ?)");
                    userStatement.setInt(1, Bankaccount.this.getId());
                    userStatement.setString(2, uuid.toString());
                    userStatement.setString(3, permission.name());
                    userStatement.execute();
                    userStatement.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
        if (Main.getChannelManager() != null) {
            Main.getChannelManager().send("bank", "adduser", (Map)ImmutableMap.of((Object)"id", (Object)("" + this.getId()), (Object)"uuid", (Object)uuid.toString(), (Object)"permission", (Object)permission.name()));
        }
    }

    public void addUserSilent(UUID uuid, BankPermission permission) {
        if (!this.users.containsKey(uuid)) {
            this.users.put(uuid, permission);
        }
    }

    public void removeUser(final UUID uuid) {
        this.removeUserSilent(uuid);
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                    PreparedStatement userStatement = connection.prepareStatement("DELETE FROM BankaccountUsers WHERE `bankId`=? AND `UUID`=?");
                    userStatement.setInt(1, Bankaccount.this.getId());
                    userStatement.setString(2, uuid.toString());
                    userStatement.execute();
                    userStatement.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
        if (Main.getChannelManager() != null) {
            Main.getChannelManager().send("bank", "removeuser", (Map)ImmutableMap.of((Object)"id", (Object)("" + this.getId()), (Object)"uuid", (Object)uuid.toString()));
        }
    }

    public void removeUserSilent(UUID uuid) {
        this.users.remove(uuid);
    }

    @Deprecated
    public void addUser(UUID user) {
        this.users.put(user, BankPermission.ADMIN);
    }

    @Deprecated
    public void addUserFromCommand(final UUID user) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try (Connection connection = PrinterAnnotationTestsPoolTask.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                    PreparedStatement userStatement = connection.prepareStatement("INSERT INTO BankaccountUsers (bankId, UUID) VALUES (?, ?)");
                    userStatement.setInt(1, Bankaccount.this.getId());
                    userStatement.setString(2, user.toString());
                    userStatement.execute();
                    userStatement.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
        if (Main.getChannelManager() != null) {
            Main.getChannelManager().send("bank", "adduser", (Map)ImmutableMap.of((Object)"id", (Object)("" + this.getId()), (Object)"uuid", (Object)user.toString(), (Object)"permission", (Object)BankPermission.ADMIN.name()));
        }
    }

    @Deprecated
    public void removeUserFromCommand(UUID user) {
        this.removeUser(user);
    }

    @Deprecated
    public void setNameWithoutChannels(String name) {
        this.setNameSilent(name);
    }

    @Deprecated
    public void setFrozenWithoutChannels(boolean frozen) {
        this.setFrozenSilent(frozen);
    }

    @Deprecated
    public void setBalanceWithoutChannels(double newBalance) {
        this.setBalanceSilent(newBalance);
    }
}

