/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.playerdata.fitness;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import nl.minetopiasdb.api.playerdata.PlayerManager;
import nl.minetopiasdb.api.playerdata.fitness.objects.OfflineFitness;
import nl.minetopiasdb.api.playerdata.fitness.objects.OnlineFitness;
import nl.minetopiasdb.api.playerdata.objects.OfflineSDBPlayer;
import nl.minetopiasdb.api.playerdata.objects.OnlineSDBPlayer;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

public class FitnessManager {
    private static FitnessManager instance;

    public static FitnessManager getInstance() {
        if (instance == null) {
            instance = new FitnessManager();
        }
        return instance;
    }

    public void loadOnlinePlayer(OnlineSDBPlayer player) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = connection.prepareStatement("SELECT `total`, `drinkingPoints`, `fitGainedByDrinking`, `fitGainedByWalking`, `fitGainedBySprinting`, `fitGainedBySwimming`, `fitGainedByClimbing`, `fitGainedByFlying`, `healthPoints`, `fitGainedByHealth`, `healthyFood`, `unhealthyFood`, `fitGainedByFood` FROM `Fitness` WHERE UUID=?");
                statement.setString(1, player.getUUID().toString());
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    int total = rs.getInt("total");
                    int drinkingPoints = rs.getInt("drinkingPoints");
                    int fitGainedByDrinking = rs.getInt("fitGainedByDrinking");
                    int fitGainedByWalking = rs.getInt("fitGainedByWalking");
                    int fitGainedBySprinting = rs.getInt("fitGainedBySprinting");
                    int fitGainedByClimbing = rs.getInt("fitGainedByClimbing");
                    int fitGainedByFlying = rs.getInt("fitGainedByFlying");
                    int fitGainedBySwimming = rs.getInt("fitGainedBySwimming");
                    int healthPoints = rs.getInt("healthPoints");
                    int fitGainedByHealth = rs.getInt("fitGainedByHealth");
                    int healthyFood = rs.getInt("healthyFood");
                    int unhealthyFood = rs.getInt("unhealthyFood");
                    int fitGainedByFood = rs.getInt("fitGainedByFood");
                    player.setFitness(new OnlineFitness(player.getUUID(), total, drinkingPoints, fitGainedByDrinking, fitGainedByWalking, fitGainedBySprinting, fitGainedByClimbing, fitGainedByFlying, fitGainedBySwimming, healthPoints, fitGainedByHealth, healthyFood, unhealthyFood, fitGainedByFood));
                } else {
                    this.addDefaults(player.getUUID());
                    this.loadOnlinePlayer(player);
                }
                rs.close();
                statement.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public void loadOfflinePlayer(OfflineSDBPlayer player) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = connection.prepareStatement("SELECT `total`, `drinkingPoints`, `fitGainedByDrinking`, `fitGainedByWalking`, `fitGainedBySprinting`, `fitGainedBySwimming`, `fitGainedByClimbing`, `fitGainedByFlying`, `healthPoints`, `fitGainedByHealth`, `healthyFood`, `unhealthyFood`, `fitGainedByFood` FROM `Fitness` WHERE UUID=?");
                statement.setString(1, player.getUUID().toString());
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    int total = rs.getInt("total");
                    int drinkingPoints = rs.getInt("drinkingPoints");
                    int fitGainedByDrinking = rs.getInt("fitGainedByDrinking");
                    int fitGainedByWalking = rs.getInt("fitGainedByWalking");
                    int fitGainedBySprinting = rs.getInt("fitGainedBySprinting");
                    int fitGainedByClimbing = rs.getInt("fitGainedByClimbing");
                    int fitGainedByFlying = rs.getInt("fitGainedByFlying");
                    int fitGainedBySwimming = rs.getInt("fitGainedBySwimming");
                    int healthPoints = rs.getInt("healthPoints");
                    int fitGainedByHealth = rs.getInt("fitGainedByHealth");
                    int healthyFood = rs.getInt("healthyFood");
                    int unhealthyFood = rs.getInt("unhealthyFood");
                    int fitGainedByFood = rs.getInt("fitGainedByFood");
                    player.setFitness(new OfflineFitness(player.getUUID(), total, drinkingPoints, fitGainedByDrinking, fitGainedByWalking, fitGainedBySprinting, fitGainedByClimbing, fitGainedByFlying, fitGainedBySwimming, healthPoints, fitGainedByHealth, healthyFood, unhealthyFood, fitGainedByFood));
                }
                rs.close();
                statement.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public boolean isInDatabase(UUID uuid) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT rowId FROM Fitness WHERE UUID=?");
                statement.setString(1, uuid.toString());
                ResultSet result = statement.executeQuery();
                boolean hasNext = result.next();
                result.close();
                statement.close();
                return hasNext;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public void addDefaults(UUID uuid) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "INSERT INTO `Fitness`(`UUID`, `total`, `drinkingPoints`, `fitGainedByDrinking`, `fitGainedByWalking`, `fitGainedBySprinting`, `fitGainedBySwimming`, `fitGainedByClimbing`, `fitGainedByFlying`, `healthPoints`, `fitGainedByHealth`, `healthyFood`, `unhealthyFood`, `fitGainedByFood`) VALUES (?,?,0,0,0,0,0,0,0,0,0,0,0,0)");
                statement.setString(1, uuid.toString());
                statement.setInt(2, TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.VRhxvGAy1wBH33));
                statement.execute();
                statement.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void pushSetsToDatabase(UUID uuid, HashMap<String, Integer> changes) {
        if (changes.isEmpty()) {
            return;
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        String setVal = "";
        for (String string : changes.keySet()) {
            setVal = String.valueOf(setVal) + "`" + string + "`=?,";
            values.add(changes.get(string));
        }
        setVal = setVal.substring(0, setVal.length() - 1);
        try {
            Throwable throwable = null;
            Iterator<String> iterator = null;
            try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = connection.prepareStatement("UPDATE Fitness SET " + setVal + " WHERE `UUID`=?");
                int parameterIndex = 1;
                for (Integer change : values) {
                    statement.setInt(parameterIndex, change);
                    ++parameterIndex;
                }
                statement.setString(parameterIndex, uuid.toString());
                statement.execute();
                statement.close();
            }
            catch (Throwable throwable2) {
                void var5_11;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var5_11;
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void checkStatistics(Player player) {
        if (PlayerManager.getOnlinePlayer(player.getUniqueId()).getFitness() == null) {
            return;
        }
        OnlineFitness fit = PlayerManager.getOnlinePlayer(player.getUniqueId()).getFitness();
        int walkPoints = fit.getFitGainedByWalking();
        int runPoints = fit.getFitGainedBySprinting();
        int swimPoints = fit.getFitGainedBySwimming();
        int climbPoints = fit.getFitGainedByClimbing();
        int flyPoints = fit.getFitGainedByFlying();
        if ((double)player.getStatistic(Statistic.WALK_ONE_CM) >= this.kmToCm(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.VZXa0zqwJEH6wZu)) && walkPoints < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.NFCz8HLeA3929Zl)) {
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setFitGainedByWalking(fit.getFitGainedByWalking() + 1);
            player.setStatistic(Statistic.WALK_ONE_CM, 0);
        } else if ((double)player.getStatistic(Statistic.SWIM_ONE_CM) >= this.kmToCm(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.N0YspZNVUacJsUO)) && swimPoints < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.PzYwz0IFn2kqw0T)) {
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setFitGainedBySwimming(fit.getFitGainedBySwimming() + 1);
            player.setStatistic(Statistic.SWIM_ONE_CM, 0);
        } else if ((double)player.getStatistic(Statistic.CLIMB_ONE_CM) > this.kmToCm(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.nr02uuWcEk09FCG)) && climbPoints < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.LoRZF1Q4WozEzll)) {
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setFitGainedByClimbing(fit.getFitGainedByClimbing() + 1);
            player.setStatistic(Statistic.CLIMB_ONE_CM, 0);
        } else if ((double)player.getStatistic(Statistic.AVIATE_ONE_CM) > this.kmToCm(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.GwulnhqC8eP1yI8)) && flyPoints < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.G4ljgB8EUCJ92Xo)) {
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setFitGainedByFlying(fit.getFitGainedByFlying() + 1);
            player.setStatistic(Statistic.AVIATE_ONE_CM, 0);
        } else if ((double)player.getStatistic(Statistic.SPRINT_ONE_CM) >= this.kmToCm(TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.R6bbx4MODwCioin)) && runPoints < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.bXOqnWy17iQx7k4)) {
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setFitGainedBySprinting(fit.getFitGainedBySprinting() + 1);
            player.setStatistic(Statistic.SPRINT_ONE_CM, 0);
        }
        PlayerManager.getOnlinePlayer(player.getUniqueId()).updateFitnessEffects();
    }

    public void healthPointsCheck(Player player) {
        OnlineFitness fit = PlayerManager.getOnlinePlayer(player.getUniqueId()).getFitness();
        if (player.getFoodLevel() >= 18) {
            fit.setHealthPoints(fit.getHealthPoints() + TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.Hk9Lqn96WYHae97));
        } else if (player.getFoodLevel() <= 4) {
            fit.setHealthPoints(fit.getHealthPoints() + TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.NyTNRkR3clX7XZn));
        } else if (player.getFoodLevel() <= 10) {
            fit.setHealthPoints(fit.getHealthPoints() + TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.g0WlDqEIeoxh4jx));
        }
        if (fit.getHealthPoints() >= 750 && fit.getFitGainedByHealth() < TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().httHooAopOc0CwK(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.gI2dfmg4aIY38RV)) {
            fit.setFitGainedByHealth(fit.getFitGainedByHealth() + 1);
            fit.setTotalFitness(fit.getTotalFitness() + 1);
            fit.setHealthPoints(0);
        }
    }

    private double kmToCm(double kilometers) {
        return kilometers * 100000.0;
    }
}

