/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.banking;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;

public class PinConsoleManager {
    private static PinConsoleManager instance;
    private HashMap<UUID, PinProgressObject> pinProgressMap = new HashMap();

    public static PinConsoleManager getInstance() {
        if (instance == null) {
            instance = new PinConsoleManager();
        }
        return instance;
    }

    public HashMap<UUID, PinProgressObject> getPinProgressMap() {
        return this.pinProgressMap;
    }

    public Map.Entry<UUID, PinProgressObject> getProgressEntryForTarget(UUID target) {
        for (Map.Entry<UUID, PinProgressObject> entry : this.pinProgressMap.entrySet()) {
            if (!entry.getValue().getTargetUUID().equals(target)) continue;
            return entry;
        }
        return null;
    }

    public static enum PinProgress {
        SELECT_BANKACCOUNT,
        SELECT_PINCONSOLE,
        TARGET_NEEDS_TO_ACCEPT;

    }

    public static class PinProgressObject {
        private UUID uuid;
        private Location consoleLocation;
        private double amount;
        private PinProgress progress;
        private int bankAccountId;

        public PinProgressObject(UUID uuid, Location consoleLocation, double amount, PinProgress progress, int bankAccountId) {
            this.uuid = uuid;
            this.consoleLocation = consoleLocation;
            this.amount = amount;
            this.progress = progress;
            this.bankAccountId = bankAccountId;
        }

        public UUID getTargetUUID() {
            return this.uuid;
        }

        public void setLocation(Location consoleLocation) {
            this.consoleLocation = consoleLocation;
        }

        public Location getConsoleLocation() {
            return this.consoleLocation;
        }

        public double getAmount() {
            return this.amount;
        }

        public void setProgress(PinProgress progress) {
            this.progress = progress;
        }

        public PinProgress getProgress() {
            return this.progress;
        }

        public void setBankAccountId(int bankAccountId) {
            this.bankAccountId = bankAccountId;
        }

        public int getBankAccountId() {
            return this.bankAccountId;
        }
    }
}

