/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.banking;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.minetopiasdb.api.enums.BankAccountType;
import nl.minetopiasdb.api.enums.BankPermission;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;
import nl.minetopiasdb.plugin.utils.MapundefinedAnnotationCollectionBroadcaster;
import org.bukkit.Bukkit;

public class Bankaccount {
    private int id;
    private String name;
    private BankAccountType type;
    private double balance;
    private boolean frozen;
    private HashMap<UUID, BankPermission> users;

    public Bankaccount(int id, BankAccountType type, double balance, String name, boolean frozen, HashMap<UUID, BankPermission> users) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.balance = balance;
        this.frozen = frozen;
        this.users = users;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public BankAccountType getType() {
        return this.type;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double newBalance) {
        double balanceChange = newBalance - this.balance;
        this.balance = newBalance;
        if (TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().Q7xyfcjMTU7Yj0x(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.nLmQGRAwv8u5Lpq)) {
            MapundefinedAnnotationCollectionBroadcaster.wkMvHiTHLyqFIhJ("BANK", String.valueOf(this.getId()) + "=splt=" + balanceChange);
        }
    }

    public void setBalanceSilent(double newBalance) {
        this.balance = newBalance;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
        if (TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().Q7xyfcjMTU7Yj0x(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.nLmQGRAwv8u5Lpq)) {
            MapundefinedAnnotationCollectionBroadcaster.wkMvHiTHLyqFIhJ("BANKFREEZE", String.valueOf(this.getId()) + "=splt=" + frozen);
        }
    }

    public void setFrozenSilent(boolean frozen) {
        this.frozen = frozen;
    }

    public List<UUID> getAuthorisedUsers() {
        return Collections.unmodifiableList(new ArrayList<UUID>(this.users.keySet()));
    }

    public Map<UUID, BankPermission> getUsers() {
        return Collections.unmodifiableMap(this.users);
    }

    public boolean hasPermission(UUID uuid, BankPermission permission) {
        if (!this.getUsers().containsKey(uuid)) {
            return false;
        }
        BankPermission userPerm = this.getUsers().get(uuid);
        return userPerm == BankPermission.ADMIN || userPerm == permission;
    }

    public void setName(String name) {
        this.name = name;
        if (TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().Q7xyfcjMTU7Yj0x(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.nLmQGRAwv8u5Lpq)) {
            MapundefinedAnnotationCollectionBroadcaster.wkMvHiTHLyqFIhJ("BARENAME", String.valueOf(this.getId()) + "=splt=" + name);
        }
    }

    public void setNameSilent(String name) {
        this.name = name;
    }

    public void addUser(final UUID uuid, final BankPermission permission) {
        this.addUserSilent(uuid, permission);
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                        PreparedStatement userStatement = connection.prepareStatement("INSERT INTO BankaccountUsers (bankId, UUID, permission) VALUES (?, ?, ?)");
                        userStatement.setInt(1, Bankaccount.this.getId());
                        userStatement.setString(2, uuid.toString());
                        userStatement.setString(3, permission.name());
                        userStatement.execute();
                        userStatement.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
        if (TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().Q7xyfcjMTU7Yj0x(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.nLmQGRAwv8u5Lpq)) {
            MapundefinedAnnotationCollectionBroadcaster.wkMvHiTHLyqFIhJ("BANKUSERADD", String.valueOf(this.getId()) + "=splt=" + uuid.toString() + "=splt=" + permission.name());
        }
    }

    public void addUserSilent(UUID uuid, BankPermission permission) {
        if (!this.users.containsKey(uuid)) {
            this.users.put(uuid, permission);
        }
    }

    public void removeUser(final UUID uuid) {
        this.removeUserSilent(uuid);
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                        PreparedStatement userStatement = connection.prepareStatement("DELETE FROM BankaccountUsers WHERE `bankId`=? AND `UUID`=?");
                        userStatement.setInt(1, Bankaccount.this.getId());
                        userStatement.setString(2, uuid.toString());
                        userStatement.execute();
                        userStatement.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
        if (TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().Q7xyfcjMTU7Yj0x(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.nLmQGRAwv8u5Lpq)) {
            MapundefinedAnnotationCollectionBroadcaster.wkMvHiTHLyqFIhJ("BANKUSERREM", String.valueOf(String.valueOf(this.getId())) + "=splt=" + uuid.toString());
        }
    }

    public void removeUserSilent(UUID uuid) {
        this.users.remove(uuid);
    }

    @Deprecated
    public void addUser(UUID user) {
        this.users.put(user, BankPermission.ADMIN);
    }

    @Deprecated
    public void addUserFromCommand(final UUID user) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                        PreparedStatement userStatement = connection.prepareStatement("INSERT INTO BankaccountUsers (bankId, UUID) VALUES (?, ?)");
                        userStatement.setInt(1, Bankaccount.this.getId());
                        userStatement.setString(2, user.toString());
                        userStatement.execute();
                        userStatement.close();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
        if (TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().Q7xyfcjMTU7Yj0x(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.nLmQGRAwv8u5Lpq)) {
            MapundefinedAnnotationCollectionBroadcaster.wkMvHiTHLyqFIhJ("BANKUSERADD", String.valueOf(this.getId()) + "=splt=" + user.toString());
        }
    }

    @Deprecated
    public void removeUserFromCommand(UUID user) {
        this.removeUser(user);
    }

    @Deprecated
    public void setNameWithoutChannels(String name) {
        this.setNameSilent(name);
    }

    @Deprecated
    public void setFrozenWithoutChannels(boolean frozen) {
        this.setFrozenSilent(frozen);
    }

    @Deprecated
    public void setBalanceWithoutChannels(double newBalance) {
        this.setBalanceSilent(newBalance);
    }
}

