/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.phone;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import nl.minetopiasdb.api.objects.Phone;
import nl.minetopiasdb.api.objects.PhoneContact;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;

public class PhoneManager {
    private static PhoneManager instance;

    public static PhoneManager getInstance() {
        if (instance == null) {
            instance = new PhoneManager();
        }
        return instance;
    }

    public List<Phone> getPhones() {
        ArrayList<Phone> phones = new ArrayList<Phone>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                ResultSet rs = conn.createStatement().executeQuery("SELECT `PHONENUMBER`, `CREDIT`, `OWNER` FROM Phones");
                while (rs.next()) {
                    phones.add(new Phone(rs.getInt("PHONENUMBER"), rs.getDouble("CREDIT"), UUID.fromString(rs.getString("OWNER"))));
                }
                rs.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return phones;
    }

    public Phone getPhone(int phonenumber) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement ps = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "SELECT `CREDIT`, `OWNER` FROM Phones WHERE PHONENUMBER=?");
                ps.setInt(1, phonenumber);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    double credit = rs.getDouble("CREDIT");
                    UUID owner = UUID.fromString(rs.getString("OWNER"));
                    rs.close();
                    return new Phone(phonenumber, credit, owner);
                }
                rs.close();
                ps.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public Phone createPhone(int phonenumber, UUID owner) {
        if (!this.isAvailable(phonenumber)) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement ps = conn.prepareStatement("INSERT INTO Phones (PHONENUMBER, CREDIT, OWNER) VALUES (?, ?, ?)");
                ps.setInt(1, phonenumber);
                ps.setDouble(2, TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().tA7f31NNkhn8WMw(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.p8wuyUF13XpFqx));
                ps.setString(3, owner.toString());
                ps.execute();
                return new Phone(phonenumber, TestsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ().tA7f31NNkhn8WMw(nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor.p8wuyUF13XpFqx), owner);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public List<PhoneContact> getContacts(int phonenumber) {
        ArrayList<PhoneContact> contacts = new ArrayList<PhoneContact>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement ps = conn.prepareStatement("SELECT PC.rowId, `PHONENUMBER_CONTACT`, `OWNER` FROM PhoneContacts PC LEFT JOIN Phones ON Phones.PHONENUMBER = PHONENUMBER_CONTACT WHERE PC.PHONENUMBER=? GROUP BY PC.rowId");
                ps.setInt(1, phonenumber);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    contacts.add(new PhoneContact(rs.getLong("rowId"), rs.getInt("PHONENUMBER_CONTACT"), UUID.fromString(rs.getString("OWNER"))));
                }
                rs.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return contacts;
    }

    public void addContact(int phonenumber, int newContact) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement ps = conn.prepareStatement("INSERT INTO PhoneContacts(PHONENUMBER, PHONENUMBER_CONTACT) VALUES (?, ?)");
                ps.setInt(1, phonenumber);
                ps.setInt(2, newContact);
                ps.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void removeContact(int phonenumber, int contact) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement ps = conn.prepareStatement("DELETE FROM PhoneContacts WHERE PHONENUMBER=? AND PHONENUMBER_CONTACT=?");
                ps.setInt(1, phonenumber);
                ps.setInt(2, contact);
                ps.execute();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isAvailable(int phonenumber) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement ps = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "SELECT rowId FROM Phones WHERE PHONENUMBER=?");
                ps.setInt(1, phonenumber);
                ResultSet rs = ps.executeQuery();
                boolean exists = rs.next();
                rs.close();
                ps.close();
                boolean bl = !exists;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return true;
        }
    }

    public int getRandomPhoneNumber() {
        int number = 10000000 + (int)(Math.random() * 9.0E7);
        if (String.valueOf(number).startsWith("06")) {
            return this.getRandomPhoneNumber();
        }
        return number;
    }
}

