/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.boosters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import nl.minetopiasdb.api.boosters.BoostType;
import nl.minetopiasdb.api.boosters.objects.ActiveBoost;
import nl.minetopiasdb.api.boosters.objects.Boost;
import nl.minetopiasdb.api.boosters.objects.BoostBar;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.httHooAopOc0CwK.TestsServiceBridgeMappingModel;
import nl.minetopiasdb.plugin.utils.MapundefinedAnnotationCollectionBroadcaster;
import org.bukkit.Bukkit;

public class BoosterManager {
    private static BoosterManager instance;
    private List<ActiveBoost> activeBoosts = new ArrayList<ActiveBoost>();
    private BoostBar luckyBar = new BoostBar(BoostType.LUCKYSHARD);
    private BoostBar goldBar = new BoostBar(BoostType.GOLDSHARD);
    private BoostBar grayBar = new BoostBar(BoostType.GRAYSHARD);

    public static BoosterManager getInstance() {
        if (instance == null) {
            instance = new BoosterManager();
        }
        return instance;
    }

    public List<Boost> getBoosters(UUID uuid, BoostType type) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                ArrayList<Boost> boosts = new ArrayList<Boost>();
                PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "SELECT rowId, BOOST_PERCENTAGE FROM Boosters WHERE UUID=? AND TYPE=?");
                statement.setString(1, uuid.toString());
                statement.setString(2, type.name());
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    boosts.add(new Boost(rs.getInt("rowId"), type, rs.getInt("BOOST_PERCENTAGE")));
                }
                rs.close();
                statement.close();
                return boosts;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void addBoost(UUID uuid, BoostType type, int percentage) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "INSERT INTO Boosters (UUID, TYPE, BOOST_PERCENTAGE) VALUES (?, ?, ?)");
                statement.setString(1, uuid.toString());
                statement.setString(2, type.name());
                statement.setInt(3, percentage);
                statement.execute();
                statement.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void removeBoost(int rowId) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "DELETE FROM Boosters WHERE rowId=?");
                statement.setInt(1, rowId);
                statement.execute();
                statement.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean removeBoost(UUID uuid, BoostType type, int percentage) {
        boolean deleted = false;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "SELECT rowId FROM Boosters WHERE UUID=? AND TYPE=? AND BOOST_PERCENTAGE=? LIMIT 1");
                statement.setString(1, uuid.toString());
                statement.setString(2, type.name());
                statement.setInt(3, percentage);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    PreparedStatement deleteStatement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "DELETE FROM Boosters WHERE rowId=?");
                    deleteStatement.setInt(1, rs.getInt("rowId"));
                    deleteStatement.execute();
                    deleteStatement.close();
                    deleted = true;
                }
                rs.close();
                statement.close();
                return deleted;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void clearBoosts(UUID uuid, BoostType type) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "DELETE FROM Boosters WHERE UUID=? AND TYPE=?");
                statement.setString(1, uuid.toString());
                statement.setString(2, type.name());
                statement.execute();
                statement.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ActiveBoost getLastActivatedBoost(BoostType type) {
        ActiveBoost boost = null;
        for (ActiveBoost activeBoost : this.getActiveBoosts(type)) {
            if (boost != null && activeBoost.getExpiryTime() <= boost.getExpiryTime()) continue;
            boost = activeBoost;
        }
        return boost;
    }

    public List<ActiveBoost> getActiveBoosts() {
        return this.activeBoosts;
    }

    public List<ActiveBoost> getActiveBoosts(BoostType type) {
        return this.activeBoosts.stream().filter(boost -> boost.getType() == type).collect(Collectors.toList());
    }

    public ActiveBoost startBoost(UUID uuid, BoostType type, int percentage) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                long expires = System.currentTimeMillis() + 3600000L;
                PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "INSERT INTO ActiveBoosters(UUID, TYPE, BOOST_PERCENTAGE, EXPIRES_ON) VALUES (?, ?, ?, ?)", 1);
                statement.setString(1, uuid.toString());
                statement.setString(2, type.name());
                statement.setInt(3, percentage);
                statement.setLong(4, expires);
                statement.executeUpdate();
                ResultSet rs = statement.getGeneratedKeys();
                int rowId = -1;
                if (rs.next()) {
                    rowId = rs.getInt(1);
                }
                rs.close();
                statement.close();
                ActiveBoost boost = new ActiveBoost(rowId, type, percentage, expires, uuid);
                this.activeBoosts.add(boost);
                this.getBar(type).reloadBar();
                MapundefinedAnnotationCollectionBroadcaster.wkMvHiTHLyqFIhJ("booststart", "yes");
                return boost;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void pullActiveBoosts() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "SELECT * FROM ActiveBoosters");
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    boolean found = false;
                    for (ActiveBoost boost2 : this.getActiveBoosts()) {
                        if (boost2.getRowId() != rs.getInt("rowId")) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    Bukkit.broadcastMessage((String)nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.httHooAopOc0CwK.ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ(null, TestsServiceBridgeMappingModel.bA).replace("<BoostType>", BoostType.valueOf(rs.getString("TYPE")).getFullName()).replace("<Player>", Bukkit.getOfflinePlayer((UUID)UUID.fromString(rs.getString("UUID"))).getName()).replace("<Percentage>", "" + rs.getInt("BOOST_PERCENTAGE")));
                    this.activeBoosts.add(new ActiveBoost(rs.getInt("rowId"), BoostType.valueOf(rs.getString("TYPE")), rs.getInt("BOOST_PERCENTAGE"), rs.getLong("EXPIRES_ON"), UUID.fromString(rs.getString("UUID"))));
                }
                rs.close();
                statement.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        BoostType[] boostTypeArray = BoostType.values();
        int n = boostTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BoostType type = boostTypeArray[n2];
            if (this.activeBoosts.stream().filter(boost -> boost.getType() == type).findFirst().isPresent()) {
                this.getBar(type).reloadBar();
            }
            ++n2;
        }
    }

    public void deleteExpiredBoosts() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(conn, "DELETE FROM ActiveBoosters WHERE EXPIRES_ON < ?");
                statement.setLong(1, System.currentTimeMillis());
                statement.execute();
                statement.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BoostBar getBar(BoostType type) {
        if (type == BoostType.LUCKYSHARD) {
            return this.luckyBar;
        }
        if (type == BoostType.GOLDSHARD) {
            return this.goldBar;
        }
        if (type == BoostType.GRAYSHARD) {
            return this.grayBar;
        }
        return null;
    }

    public int getTotalBoost(BoostType type) {
        int totalBoost = 0;
        for (ActiveBoost boost2 : this.getActiveBoosts().stream().filter(boost -> boost.getType() == type).collect(Collectors.toList())) {
            totalBoost += boost2.getPercentage();
        }
        return totalBoost;
    }
}

