/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.playerdata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import nl.minetopiasdb.api.playerdata.fitness.FitnessManager;
import nl.minetopiasdb.api.playerdata.fitness.boost.FitnessBoost;
import nl.minetopiasdb.api.playerdata.fitness.boost.FitnessBoostManager;
import nl.minetopiasdb.api.playerdata.fitness.objects.Fitness;
import nl.minetopiasdb.api.playerdata.objects.OfflineSDBPlayer;
import nl.minetopiasdb.api.playerdata.objects.OnlineSDBPlayer;
import nl.minetopiasdb.api.playerdata.objects.SDBPlayer;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK.wkMvHiTHLyqFIhJ.ContainerListenerRepositoryVisitor;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK.wkMvHiTHLyqFIhJ.TestsServiceBridgeMappingModel;
import nl.minetopiasdb.plugin.utils.MapundefinedAnnotationCollectionBroadcaster;
import org.bukkit.Bukkit;

public class PlayerManager {
    private ConcurrentHashMap<UUID, OnlineSDBPlayer> sdbplayers = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, OfflineSDBPlayer> cachedofflineplayers = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, List<TestsServiceBridgeMappingModel>> changes = new ConcurrentHashMap();
    private ArrayList<UUID> dataLoading = new ArrayList();
    private static PlayerManager instance;

    public static PlayerManager getInstance() {
        if (instance == null) {
            instance = new PlayerManager();
        }
        return instance;
    }

    public Collection<OnlineSDBPlayer> getOnlinePlayers() {
        return this.sdbplayers.values();
    }

    public static SDBPlayer getPlayer(UUID uuid) {
        return PlayerManager.getInstance().getPlayer0(uuid);
    }

    public static OnlineSDBPlayer getOnlinePlayer(UUID uuid) {
        return PlayerManager.getInstance().getOnlinePlayer0(uuid);
    }

    public static OfflineSDBPlayer getOfflinePlayer(UUID uuid) {
        return PlayerManager.getInstance().getOfflinePlayer0(uuid);
    }

    private OnlineSDBPlayer getOnlinePlayer0(UUID uuid) {
        return this.sdbplayers.get(uuid);
    }

    private SDBPlayer getPlayer0(UUID uuid) {
        if (this.sdbplayers.containsKey(uuid)) {
            return this.getOnlinePlayer0(uuid);
        }
        return this.getOfflinePlayer0(uuid);
    }

    private OfflineSDBPlayer getOfflinePlayer0(UUID uuid) {
        if (this.cachedofflineplayers.contains(uuid)) {
            return this.cachedofflineplayers.get(uuid);
        }
        OfflineSDBPlayer target = new OfflineSDBPlayer(uuid);
        FitnessManager.getInstance().loadOfflinePlayer(target);
        this.cachedofflineplayers.remove(uuid);
        this.cachedofflineplayers.put(uuid, target);
        return target;
    }

    public boolean isInDatabase(UUID uuid) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT rowId FROM Players WHERE UUID=?");
                statement.setString(1, uuid.toString());
                ResultSet result = statement.executeQuery();
                boolean hasNext = result.next();
                result.close();
                statement.close();
                return hasNext;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public void addDefaults(UUID uuid) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                String values = "";
                String questionmarks = "";
                ArrayList<Object> defaultValue = new ArrayList<Object>();
                ContainerListenerRepositoryVisitor[] containerListenerRepositoryVisitorArray = ContainerListenerRepositoryVisitor.Q7xyfcjMTU7Yj0x();
                int n = containerListenerRepositoryVisitorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContainerListenerRepositoryVisitor data = containerListenerRepositoryVisitorArray[n2];
                    values = String.valueOf(values) + data.wkMvHiTHLyqFIhJ() + ",";
                    questionmarks = String.valueOf(questionmarks) + "?,";
                    defaultValue.add(data.httHooAopOc0CwK());
                    ++n2;
                }
                values = values.substring(0, values.length() - 1);
                questionmarks = questionmarks.substring(0, questionmarks.length() - 1);
                PreparedStatement statement = connection.prepareStatement("INSERT INTO Players (" + values + ") VALUES (" + questionmarks + ")");
                int parameterIndex = 1;
                for (Object e2 : defaultValue) {
                    if (e2 instanceof Double) {
                        statement.setDouble(parameterIndex, (Double)e2);
                    } else if (e2 instanceof String) {
                        statement.setString(parameterIndex, ((String)e2).replace("[uuid]", uuid.toString()));
                    } else if (e2 instanceof Integer) {
                        statement.setInt(parameterIndex, (Integer)e2);
                    } else if (e2 instanceof Boolean) {
                        statement.setInt(parameterIndex, (Boolean)e2 != false ? 1 : 0);
                    } else if (e2 == null) {
                        statement.setNull(parameterIndex, 12);
                    }
                    ++parameterIndex;
                }
                statement.execute();
                statement.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public void loadPlayer(UUID uuid) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT `prefix`, `prefixcolor`, `selectedchatcolor`, `citycolor`, `levelcolor`, `level`, `chatspy`, `commandspy`, `staffchat`, `graycoins`, `goldshards`, `grayshards`, `luckyshards`, `timeSeconds`, `timeMinutes`, `timeHours`, `timeDays`, `deathbanTime`, `handcuffed`, `handcuffedBy`, `fitnessreset` FROM `Players` WHERE UUID=?");
                statement.setString(1, uuid.toString());
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    String prefix = rs.getString("prefix");
                    String prefixcolor = rs.getString("prefixcolor");
                    String chatcolor = rs.getString("selectedchatcolor");
                    String citycolor = rs.getString("citycolor");
                    String levelcolor = rs.getString("levelcolor");
                    int level = rs.getInt("level");
                    boolean chatspy = rs.getInt("chatspy") != 0;
                    boolean fitnessreset = rs.getInt("fitnessreset") != 0;
                    boolean commandspy = rs.getInt("commandspy") != 0;
                    boolean staffchat = rs.getInt("staffchat") != 0;
                    int graycoins = rs.getInt("graycoins");
                    double goldshards = rs.getDouble("goldshards");
                    double grayshards = rs.getDouble("grayshards");
                    double luckyshards = rs.getDouble("luckyshards");
                    int timeseconds = rs.getInt("timeSeconds");
                    int timeminutes = rs.getInt("timeMinutes");
                    int timehours = rs.getInt("timeHours");
                    int timedays = rs.getInt("timeDays");
                    boolean handcuffed = rs.getInt("handcuffed") != 0;
                    UUID handcuffedBy = rs.getString("handcuffedBy") == null ? null : UUID.fromString(rs.getString("handcuffedBy"));
                    long deathbanTime = rs.getLong("deathbanTime");
                    OnlineSDBPlayer player = new OnlineSDBPlayer(uuid, prefix, prefixcolor, chatcolor, citycolor, levelcolor, level, chatspy, commandspy, staffchat, graycoins, goldshards, grayshards, luckyshards, null, timeseconds, timeminutes, timehours, timedays, deathbanTime, handcuffed, handcuffedBy, fitnessreset);
                    this.sdbplayers.put(uuid, player);
                }
                rs.close();
                statement.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public void quit(UUID uuid) {
        this.sdbplayers.remove(uuid);
    }

    public List<UUID> getChangedUsers() {
        return Collections.list(this.changes.keys());
    }

    public void manageSet(UUID who, String path, Object value) {
        TestsServiceBridgeMappingModel data = new TestsServiceBridgeMappingModel(path, value);
        ArrayList<TestsServiceBridgeMappingModel> playerChanges = new ArrayList<TestsServiceBridgeMappingModel>();
        if (this.changes.containsKey(who)) {
            playerChanges.addAll((Collection)this.changes.get(who));
            for (TestsServiceBridgeMappingModel loopedData : new ArrayList(playerChanges)) {
                if (!loopedData.wkMvHiTHLyqFIhJ().equalsIgnoreCase(path)) continue;
                playerChanges.remove(loopedData);
            }
        }
        playerChanges.add(data);
        this.changes.remove(who);
        this.changes.put(who, playerChanges);
    }

    /*
     * WARNING - void declaration
     */
    public void pushSetsToDatabase(UUID uuid) {
        if (this.changes.get(uuid) == null) {
            return;
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String setVal = "";
        for (TestsServiceBridgeMappingModel testsServiceBridgeMappingModel : this.changes.get(uuid)) {
            setVal = String.valueOf(setVal) + "`" + testsServiceBridgeMappingModel.wkMvHiTHLyqFIhJ() + "`=?,";
            values.add(testsServiceBridgeMappingModel.httHooAopOc0CwK());
        }
        setVal = setVal.substring(0, setVal.length() - 1);
        try {
            try {
                Throwable throwable = null;
                Iterator<TestsServiceBridgeMappingModel> iterator = null;
                try (Connection connection = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                    PreparedStatement statement = connection.prepareStatement("UPDATE Players SET " + setVal + " WHERE `UUID`=?");
                    int parameterIndex = 1;
                    for (Object e2 : values) {
                        if (e2 instanceof Double) {
                            statement.setDouble(parameterIndex, (Double)e2);
                        } else if (e2 instanceof String) {
                            statement.setString(parameterIndex, (String)e2);
                        } else if (e2 instanceof Integer) {
                            statement.setInt(parameterIndex, (Integer)e2);
                        } else if (e2 instanceof Boolean) {
                            statement.setInt(parameterIndex, (Boolean)e2 != false ? 1 : 0);
                        } else if (e2 instanceof Long) {
                            statement.setLong(parameterIndex, (Long)e2);
                        } else if (e2 == null) {
                            statement.setNull(parameterIndex, 12);
                        }
                        ++parameterIndex;
                    }
                    statement.setString(parameterIndex, uuid.toString());
                    statement.execute();
                    statement.close();
                }
                catch (Throwable throwable2) {
                    void var4_10;
                    if (throwable == null) {
                        Throwable throwable3 = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw var4_10;
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                this.changes.remove(uuid);
            }
        }
        finally {
            this.changes.remove(uuid);
        }
    }

    public boolean isLoading(UUID uuid) {
        return this.dataLoading.contains(uuid);
    }

    public void setLoading(UUID uuid) {
        this.dataLoading.add(uuid);
    }

    public void stopLoading(UUID uuid) {
        this.dataLoading.remove(uuid);
    }

    public boolean isOfflineCached(UUID uuid) {
        return this.cachedofflineplayers.containsKey(uuid);
    }

    public void removeFromOfflineCache(UUID uuid) {
        this.cachedofflineplayers.remove(uuid);
    }

    public void clearOfflineCache() {
        this.cachedofflineplayers.clear();
    }

    public void removeFromChangeCache(UUID uuid) {
        this.changes.remove(uuid);
    }

    public void swap(UUID source, UUID target) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Connection connection = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                int sourceBoosts = FitnessBoostManager.getInstance().getFitnessBoosts(false).stream().filter(boost -> boost.getUUID().equals(source)).mapToInt(FitnessBoost::getFitness).sum();
                int targetBoosts = FitnessBoostManager.getInstance().getFitnessBoosts(false).stream().filter(boost -> boost.getUUID().equals(target)).mapToInt(FitnessBoost::getFitness).sum();
                SDBPlayer sourcePlayer = PlayerManager.getPlayer(source);
                SDBPlayer targetPlayer = PlayerManager.getPlayer(target);
                Fitness sourcePlayerFit = sourcePlayer.getFitness();
                sourcePlayerFit.setTotalFitness(sourcePlayerFit.getTotalFitness() - sourceBoosts);
                Fitness targetPlayerFit = targetPlayer.getFitness();
                targetPlayerFit.setTotalFitness(targetPlayerFit.getTotalFitness() - targetBoosts);
                if (sourcePlayer instanceof OnlineSDBPlayer) {
                    FitnessManager.getInstance().pushSetsToDatabase(sourcePlayer.getUUID(), ((OnlineSDBPlayer)sourcePlayer).getFitness().getChanges());
                }
                if (targetPlayer instanceof OnlineSDBPlayer) {
                    FitnessManager.getInstance().pushSetsToDatabase(targetPlayer.getUUID(), ((OnlineSDBPlayer)targetPlayer).getFitness().getChanges());
                }
                int rowIdTarget = this.getRowId(target, "Players", connection);
                int rowIdSource = this.getRowId(source, "Players", connection);
                this.changeUUID(target, "Players", rowIdSource, connection);
                this.changeUUID(source, "Players", rowIdTarget, connection);
                int fitRowIdTarget = this.getRowId(target, "Fitness", connection);
                int fitRowIdSource = this.getRowId(source, "Fitness", connection);
                this.changeUUID(target, "Fitness", fitRowIdSource, connection);
                this.changeUUID(source, "Fitness", fitRowIdTarget, connection);
                MapundefinedAnnotationCollectionBroadcaster.wkMvHiTHLyqFIhJ("clearcache", source.toString());
                MapundefinedAnnotationCollectionBroadcaster.wkMvHiTHLyqFIhJ("clearcache", target.toString());
                PlayerManager.getInstance().removeFromOfflineCache(source);
                PlayerManager.getInstance().quit(source);
                PlayerManager.getInstance().removeFromOfflineCache(target);
                PlayerManager.getInstance().quit(target);
                if (Bukkit.getPlayer((UUID)source) != null) {
                    PlayerManager.getInstance().loadPlayer(source);
                    FitnessManager.getInstance().loadOnlinePlayer(PlayerManager.getOnlinePlayer(source));
                }
                if (Bukkit.getPlayer((UUID)target) != null) {
                    PlayerManager.getInstance().loadPlayer(target);
                    FitnessManager.getInstance().loadOnlinePlayer(PlayerManager.getOnlinePlayer(target));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    private int getRowId(UUID uuid, String table, Connection connection) throws SQLException {
        int rowId = -1;
        PreparedStatement statement = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT rowId FROM `" + table + "` WHERE `UUID`=?");
        statement.setString(1, uuid.toString());
        ResultSet rs = statement.executeQuery();
        if (rs.next()) {
            rowId = rs.getInt("rowId");
        }
        rs.close();
        statement.close();
        return rowId;
    }

    private void changeUUID(UUID newUuid, String table, int rowId, Connection connection) throws SQLException {
        PreparedStatement statement = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "UPDATE `" + table + "` SET `UUID`=? WHERE `rowId`=?");
        statement.setString(1, newUuid.toString());
        statement.setInt(2, rowId);
        statement.execute();
        statement.close();
    }
}

