/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.playerdata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.minetopiasdb.api.enums.ColorType;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor;
import org.bukkit.Bukkit;

public class ColorManager {
    private static ColorManager instance;
    private HashMap<Map.Entry<UUID, ColorType>, List<String>> cachedColors = new HashMap();

    public static ColorManager getInstance() {
        if (instance == null) {
            instance = new ColorManager();
        }
        return instance;
    }

    public List<String> getColors(UUID uuid, ColorType type) {
        for (Map.Entry<UUID, ColorType> entry : this.cachedColors.keySet()) {
            if (entry.getKey() != uuid || entry.getValue() != type) continue;
            return this.cachedColors.get(entry);
        }
        ArrayList<String> colors = new ArrayList<String>();
        try {
            Object object = null;
            Object var5_7 = null;
            try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                PreparedStatement statement = connection.prepareStatement("SELECT `color` FROM `" + type.getDatabase() + "` WHERE UUID=?");
                statement.setString(1, uuid.toString());
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    colors.add(rs.getString("color"));
                }
                rs.close();
                statement.close();
                this.cachedColors.put(new AbstractMap.SimpleEntry<UUID, ColorType>(uuid, type), colors);
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return colors;
    }

    public void removeFromCache(UUID uuid, ColorType type) {
        for (Map.Entry<UUID, ColorType> entry : new ArrayList<Map.Entry<UUID, ColorType>>(this.cachedColors.keySet())) {
            if (entry.getKey() != uuid || entry.getValue() != type) continue;
            this.cachedColors.remove(entry);
        }
    }

    public void addColor(final UUID uuid, final String color, final ColorType type) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                        PreparedStatement statement = connection.prepareStatement("INSERT INTO `" + type.getDatabase() + "` (UUID, color) VALUES (?, ?)");
                        statement.setString(1, uuid.toString());
                        statement.setString(2, color);
                        statement.execute();
                        statement.close();
                        for (Map.Entry entry : new ArrayList(ColorManager.this.cachedColors.keySet())) {
                            if (entry.getKey() != uuid || entry.getValue() != type) continue;
                            List colors = (List)ColorManager.this.cachedColors.get(entry);
                            colors.add(color);
                            ColorManager.this.cachedColors.remove(entry);
                            ColorManager.this.cachedColors.put(entry, colors);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    public void removeColor(final UUID uuid, final String color, final ColorType type) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                        PreparedStatement statement = connection.prepareStatement("DELETE FROM `" + type.getDatabase() + "` WHERE UUID=? AND color=?");
                        statement.setString(1, uuid.toString());
                        statement.setString(2, color);
                        statement.execute();
                        statement.close();
                        for (Map.Entry entry : new ArrayList(ColorManager.this.cachedColors.keySet())) {
                            if (entry.getKey() != uuid || entry.getValue() != type) continue;
                            List colors = (List)ColorManager.this.cachedColors.get(entry);
                            colors.remove(color);
                            ColorManager.this.cachedColors.remove(entry);
                            ColorManager.this.cachedColors.put(entry, colors);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    public void reset(final UUID uuid, final ColorType type) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try {
                    Throwable throwable = null;
                    Object var2_4 = null;
                    try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                        PreparedStatement statement = connection.prepareStatement("DELETE FROM `" + type.getDatabase() + "` WHERE UUID=?");
                        statement.setString(1, uuid.toString());
                        statement.execute();
                        statement.close();
                        for (Map.Entry entry : new ArrayList(ColorManager.this.cachedColors.keySet())) {
                            if (entry.getKey() != uuid || entry.getValue() != type) continue;
                            ColorManager.this.cachedColors.remove(entry);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    public void swap(UUID a2, UUID b2, ColorType type) {
        this.removeFromCache(a2, type);
        this.removeFromCache(b2, type);
        ArrayList<Integer> rowIdsA = new ArrayList<Integer>();
        ArrayList<Integer> rowIdsB = new ArrayList<Integer>();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection conn = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                int i2;
                String statement;
                PreparedStatement selectA = conn.prepareStatement("SELECT rowId FROM `" + type.getDatabase() + "` WHERE UUID=?");
                selectA.setString(1, a2.toString());
                ResultSet rsA = selectA.executeQuery();
                while (rsA.next()) {
                    rowIdsA.add(rsA.getInt("rowId"));
                }
                rsA.close();
                selectA.close();
                PreparedStatement selectB = conn.prepareStatement("SELECT rowId FROM `" + type.getDatabase() + "` WHERE UUID=?");
                selectB.setString(1, b2.toString());
                ResultSet rsB = selectB.executeQuery();
                while (rsB.next()) {
                    rowIdsB.add(rsB.getInt("rowId"));
                }
                rsB.close();
                selectB.close();
                if (rowIdsA.size() > 0) {
                    statement = "UPDATE `" + type.getDatabase() + "` SET UUID=? WHERE rowId=?";
                    if (rowIdsA.size() > 1) {
                        int i3 = 1;
                        while (i3 < rowIdsA.size()) {
                            statement = String.valueOf(statement) + " OR rowId=? ";
                            ++i3;
                        }
                    }
                    PreparedStatement updateA = conn.prepareStatement(statement);
                    updateA.setString(1, b2.toString());
                    i2 = 0;
                    while (i2 < rowIdsA.size()) {
                        updateA.setInt(i2 + 2, (Integer)rowIdsA.get(i2));
                        ++i2;
                    }
                    updateA.execute();
                    updateA.close();
                }
                if (rowIdsB.size() > 0) {
                    statement = "UPDATE `" + type.getDatabase() + "` SET UUID=? WHERE rowId=?";
                    if (rowIdsB.size() > 1) {
                        int i4 = 1;
                        while (i4 < rowIdsB.size()) {
                            statement = String.valueOf(statement) + " OR rowId=? ";
                            ++i4;
                        }
                    }
                    PreparedStatement updateB = conn.prepareStatement(statement);
                    updateB.setString(1, a2.toString());
                    i2 = 0;
                    while (i2 < rowIdsB.size()) {
                        updateB.setInt(i2 + 2, (Integer)rowIdsB.get(i2));
                        ++i2;
                    }
                    updateB.execute();
                    updateB.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

