/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.playerdata.fitness.boost;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import nl.minetopiasdb.api.API;
import nl.minetopiasdb.api.playerdata.PlayerManager;
import nl.minetopiasdb.api.playerdata.fitness.boost.FitnessBoost;
import nl.minetopiasdb.api.playerdata.objects.OnlineSDBPlayer;
import nl.minetopiasdb.api.playerdata.objects.SDBPlayer;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.ContainerListenerRepositoryVisitor;

public class FitnessBoostManager {
    private static FitnessBoostManager instance;

    public static FitnessBoostManager getInstance() {
        if (instance == null) {
            instance = new FitnessBoostManager();
        }
        return instance;
    }

    public List<FitnessBoost> getFitnessBoosts(boolean expired) {
        ArrayList<FitnessBoost> arrayList;
        block9: {
            ArrayList<FitnessBoost> boosts = new ArrayList<FitnessBoost>();
            Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
            try {
                String statementStr = "";
                statementStr = expired ? "SELECT `UUID`, `fitness`, `expiresOn` FROM `FitnessBoosts` WHERE expiresOn <= " + System.currentTimeMillis() : "SELECT `UUID`, `fitness`, `expiresOn` FROM `FitnessBoosts`";
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery(statementStr);
                while (rs.next()) {
                    String uuid = rs.getString("UUID");
                    int fitness = rs.getInt("fitness");
                    long expiresOn = rs.getLong("expiresOn");
                    boosts.add(new FitnessBoost(UUID.fromString(uuid), fitness, expiresOn));
                }
                rs.close();
                statement.close();
                arrayList = boosts;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    return null;
                }
            }
            connection.close();
        }
        return arrayList;
    }

    public void createBoost(UUID uuid, int fitness, int minutes) {
        SDBPlayer player = PlayerManager.getPlayer(uuid);
        player.getFitness().setTotalFitness(player.getFitness().getTotalFitness() + fitness);
        if (player instanceof OnlineSDBPlayer) {
            ((OnlineSDBPlayer)player).updateFitnessEffects();
        }
        try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "INSERT INTO `FitnessBoosts` (`UUID`, `fitness`, `expiresOn`) VALUES (?, ?, ?)");
            statement.setString(1, uuid.toString());
            statement.setInt(2, fitness);
            statement.setLong(3, System.currentTimeMillis() + (long)(minutes * 60000));
            statement.execute();
            statement.close();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    private void removeInactiveBoosts() {
        try (Connection connection = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = ContainerListenerRepositoryVisitor.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "DELETE FROM `FitnessBoosts` WHERE expiresOn <= " + System.currentTimeMillis());
            statement.execute();
            statement.close();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public void manageTask() {
        List<FitnessBoost> boosters = this.getFitnessBoosts(true);
        this.removeInactiveBoosts();
        for (FitnessBoost boost : boosters) {
            SDBPlayer player = PlayerManager.getPlayer(boost.getUUID());
            player.getFitness().setTotalFitness(player.getFitness().getTotalFitness() - boost.getFitness());
            if (!(player instanceof OnlineSDBPlayer)) continue;
            ((OnlineSDBPlayer)player).updateFitnessEffects();
            API.updateScoreboard(((OnlineSDBPlayer)player).getPlayer());
        }
    }
}

