/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.boosters.objects;

import java.util.UUID;
import nl.minetopiasdb.api.boosters.BoostType;
import nl.minetopiasdb.api.boosters.BoosterManager;
import nl.minetopiasdb.api.boosters.objects.ActiveBoost;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BoostBar {
    private BossBar bar;
    private BoostType type;

    public BoostBar(BoostType type) {
        this.type = type;
    }

    public void createBossBarForAll() {
        ActiveBoost lastActivated;
        if (Bukkit.getOnlinePlayers().size() == 0) {
            return;
        }
        if (this.bar != null) {
            this.bar.removeAll();
        }
        if ((lastActivated = BoosterManager.getInstance().getLastActivatedBoost(this.type)) == null) {
            return;
        }
        this.bar = this.getBar((Player)Bukkit.getOnlinePlayers().iterator().next(), lastActivated);
        for (Player all : Bukkit.getOnlinePlayers()) {
            this.bar.addPlayer(all);
        }
    }

    public void addPlayerToBar(Player player) {
        if (this.bar != null) {
            this.bar.addPlayer(player);
        }
    }

    public void reloadBar() {
        if (this.bar != null) {
            this.bar.removeAll();
        }
        this.bar = null;
        this.createBossBarForAll();
    }

    public void removeBarOnShutdown() {
        if (this.bar != null) {
            this.bar.removeAll();
            this.bar.setVisible(false);
        }
    }

    public BossBar getBar(Player player, ActiveBoost lastActivated) {
        BossBar bar = Bukkit.createBossBar((String)this.type.getBossBarMSG((CommandSender)player).replace("<Percentage>", "" + BoosterManager.getInstance().getTotalBoost(this.type)).replace("<LastBooster>", Bukkit.getOfflinePlayer((UUID)lastActivated.getBoosterActivator()).getName()), (BarColor)this.type.getColor(), (BarStyle)BarStyle.SEGMENTED_20, (BarFlag[])new BarFlag[0]);
        bar.setProgress(1.0);
        return bar;
    }

    public void setBarLeft(double part) {
        if (this.bar != null) {
            this.bar.setProgress(part);
        }
    }
}

