/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.playerdata.objects;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.UUID;
import nl.minetopiasdb.api.enums.LevelChangeReason;
import nl.minetopiasdb.api.events.player.PlayerChangeLevelEvent;
import nl.minetopiasdb.api.playerdata.PlayerManager;
import nl.minetopiasdb.api.playerdata.objects.SDBPlayer;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK.httHooAopOc0CwK.httHooAopOc0CwK;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.tA7f31NNkhn8WMw;
import org.apache.commons.lang.Validate;

public class OfflineSDBPlayer
implements SDBPlayer {
    private UUID uuid;
    private UUID handcuffedBy;
    private String prefix;
    private String prefixcolor;
    private String selectedChatcolor;
    private String citycolor;
    private String levelcolor;
    private int level;
    private int graycoins;
    private int seconds;
    private int minutes;
    private int days;
    private int hours;
    private boolean chatspy;
    private boolean commandspy;
    private boolean fitnessreset;
    private boolean staffchat;
    private boolean handcuffed;
    private double luckyshards;
    private double goldshards;
    private double grayshards;
    private wkMvHiTHLyqFIhJ fitness;
    private long deathbanTime;

    public OfflineSDBPlayer(UUID uuid) {
        this.uuid = uuid;
        this.reloadDataFromDB();
    }

    public void reloadDataFromDB() {
        try (Connection connection = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT `prefix`, `prefixcolor`, `selectedchatcolor`, `citycolor`, `levelcolor`, `level`, `chatspy`, `fitnessreset`, `commandspy`, `staffchat`, `graycoins`, `goldshards`, `grayshards`, `luckyshards`, `timeSeconds`, `timeMinutes`, `timeHours`, `timeDays`, `deathbanTime`, `handcuffed`, `handcuffedBy` FROM `Players` WHERE UUID=?");
            statement.setString(1, this.uuid.toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                this.prefix = rs.getString("prefix");
                this.prefixcolor = rs.getString("prefixcolor");
                this.selectedChatcolor = rs.getString("selectedchatcolor");
                this.citycolor = rs.getString("citycolor");
                this.levelcolor = rs.getString("levelcolor");
                this.level = rs.getInt("level");
                this.chatspy = rs.getInt("chatspy") != 0;
                this.fitnessreset = rs.getInt("fitnessreset") != 0;
                this.commandspy = rs.getInt("commandspy") != 0;
                this.staffchat = rs.getInt("staffchat") != 0;
                this.graycoins = rs.getInt("graycoins");
                this.goldshards = rs.getDouble("goldshards");
                this.grayshards = rs.getDouble("grayshards");
                this.luckyshards = rs.getDouble("luckyshards");
                this.seconds = rs.getInt("timeSeconds");
                this.minutes = rs.getInt("timeMinutes");
                this.hours = rs.getInt("timeHours");
                this.days = rs.getInt("timeDays");
                this.deathbanTime = rs.getLong("deathbanTime");
                this.handcuffed = rs.getInt("handcuffed") != 0;
                this.handcuffedBy = rs.getString("handcuffedBy") == null ? null : UUID.fromString(rs.getString("handcuffedBy"));
            }
            rs.close();
            statement.close();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.wkMvHiTHLyqFIhJ, prefix);
    }

    @Override
    public String getPrefixColor() {
        return this.prefixcolor;
    }

    @Override
    public void setPrefixColor(String prefixcolor) {
        this.prefixcolor = prefixcolor;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.httHooAopOc0CwK, prefixcolor);
    }

    @Override
    public String getSelectedChatColor() {
        return this.selectedChatcolor;
    }

    @Override
    public void setSelectedChatColor(String selectedChatcolor) {
        this.selectedChatcolor = selectedChatcolor;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.gw9TobFYulBnouD, selectedChatcolor);
    }

    @Override
    public String getCitycolor() {
        return this.citycolor;
    }

    @Override
    public void setCitycolor(String citycolor) {
        this.citycolor = citycolor;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.ueGwmU6NmtFlkjo, citycolor);
    }

    @Override
    public String getLevelColor() {
        return this.levelcolor;
    }

    @Override
    public void setLevelColor(String levelcolor) {
        this.levelcolor = levelcolor;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.Q7xyfcjMTU7Yj0x, levelcolor);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level, LevelChangeReason reason) {
        if (!PlayerChangeLevelEvent.setLevel(this, level, reason)) {
            this.level = level;
            tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.tA7f31NNkhn8WMw, (Object)level);
        }
    }

    @Override
    public boolean hasChatspy() {
        return this.chatspy;
    }

    @Override
    public void setChatSpy(boolean chatspy) {
        this.chatspy = chatspy;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.gsYn2Y0YeZxKYo, chatspy);
    }

    @Override
    public boolean hasFitnessReset() {
        return this.fitnessreset;
    }

    @Override
    public void setFitnessReset(boolean fitnessreset) {
        this.fitnessreset = fitnessreset;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.hljMeKlytHYH64A, fitnessreset);
    }

    @Override
    public boolean hasCommandSpy() {
        return this.commandspy;
    }

    @Override
    public void setCommandSpy(boolean commandspy) {
        this.commandspy = commandspy;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.oOykE2E4KbbwLCc, commandspy);
    }

    @Override
    public boolean hasStaffChat() {
        return this.staffchat;
    }

    @Override
    public void setStaffChat(boolean staffchat) {
        this.staffchat = staffchat;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.xZq15x08E3T5Fql, staffchat);
    }

    @Override
    public int getGrayCoins() {
        return this.graycoins;
    }

    @Override
    public void setGrayCoins(int graycoins) {
        this.graycoins = graycoins;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.LuZKeqZZNinpwYh, (Object)graycoins);
    }

    @Override
    public double getGoldShards() {
        return this.goldshards;
    }

    @Override
    public String getGoldShardsFormatted() {
        DecimalFormat df2 = new DecimalFormat("0.000");
        return df2.format(this.goldshards).replace(",", ".");
    }

    @Override
    public void setGoldShards(double goldshards) {
        this.goldshards = goldshards;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.nLmQGRAwv8u5Lpq, goldshards);
    }

    @Override
    public double getGrayShards() {
        return this.grayshards;
    }

    @Override
    public String getGrayShardsFormatted() {
        DecimalFormat df2 = new DecimalFormat("0.0");
        return df2.format(this.grayshards).replace(",", ".");
    }

    @Override
    public void setGrayShards(double grayshards) {
        this.grayshards = grayshards;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.zvlHDbUJDnV24k, grayshards);
    }

    @Override
    public double getLuckyShards() {
        return this.luckyshards;
    }

    @Override
    public String getLuckyShardsFormatted() {
        DecimalFormat df2 = new DecimalFormat("0.000");
        return df2.format(this.luckyshards).replace(",", ".");
    }

    @Override
    public void setLuckyShards(double luckyshards) {
        this.luckyshards = luckyshards;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.Fok7Yz26GmRgR3, luckyshards);
    }

    @Override
    public wkMvHiTHLyqFIhJ getFitness() {
        return this.fitness;
    }

    @Override
    public void setFitness(wkMvHiTHLyqFIhJ fitness) {
        this.fitness = fitness;
    }

    @Override
    public int getTimeSeconds() {
        return this.seconds;
    }

    @Override
    public void setTimeSeconds(int seconds) {
        this.seconds = seconds;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.fZyZEn5LFYJ0EOg, (Object)seconds);
    }

    @Override
    public int getTimeMinutes() {
        return this.minutes;
    }

    @Override
    public void setTimeMinutes(int minutes) {
        this.minutes = minutes;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.RzKLSWLheSUB9ux, (Object)minutes);
    }

    @Override
    public int getTimeHours() {
        return this.hours;
    }

    @Override
    public void setTimeHours(int hours) {
        this.hours = hours;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.ZRFdGS5enlKakTo, (Object)hours);
    }

    @Override
    public int getTimeDays() {
        return this.days;
    }

    @Override
    public void setTimeDays(int days) {
        this.days = days;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.s5Q7mZgfgJQUQnp, (Object)days);
    }

    @Override
    public void setPrefixSilent(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void setPrefixColorSilent(String prefixcolor) {
        this.prefixcolor = prefixcolor;
    }

    @Override
    public void setSelectedChatColorSilent(String selectedChatcolor) {
        this.selectedChatcolor = selectedChatcolor;
    }

    @Override
    public void setCitycolorSilent(String citycolor) {
        this.citycolor = citycolor;
    }

    @Override
    public void setLevelColorSilent(String levelcolor) {
        this.levelcolor = levelcolor;
    }

    @Override
    public void setLevelSilent(int level) {
        this.level = level;
    }

    @Override
    public void setChatSpySilent(boolean chatspy) {
        this.chatspy = chatspy;
    }

    @Override
    public void setFitnessResetSilent(boolean fitnessreset) {
        this.fitnessreset = fitnessreset;
    }

    @Override
    public void setCommandSpySilent(boolean commandspy) {
        this.commandspy = commandspy;
    }

    @Override
    public void setStaffChatSilent(boolean staffchat) {
        this.staffchat = staffchat;
    }

    @Override
    public void setGrayCoinsSilent(int graycoins) {
        this.graycoins = graycoins;
    }

    @Override
    public void setGoldShardsSilent(double goldshards) {
        this.goldshards = goldshards;
    }

    @Override
    public void setGrayShardsSilent(double grayshards) {
        this.grayshards = grayshards;
    }

    @Override
    public void setLuckyShardsSilent(double luckyshards) {
        this.luckyshards = luckyshards;
    }

    @Override
    public void setTimeSecondsSilent(int seconds) {
        this.seconds = seconds;
    }

    @Override
    public void setTimeMinutesSilent(int minutes) {
        this.minutes = minutes;
    }

    @Override
    public void setTimeHoursSilent(int hours) {
        this.hours = hours;
    }

    @Override
    public void setTimeDaysSilent(int days) {
        this.days = days;
    }

    @Override
    public long getDeathbanTime() {
        return this.deathbanTime;
    }

    @Override
    public void setDeathbanTime(long deathbanmillis) {
        this.deathbanTime = deathbanmillis;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.WpHEgOonrTGSvFl, deathbanmillis);
    }

    @Override
    public void setDeathbanTimeSilent(long deathbanmillis) {
        this.deathbanTime = deathbanmillis;
    }

    @Override
    public void handcuffPlayer(UUID handcuffedBy) {
        Validate.notNull((Object)handcuffedBy);
        this.handcuffed = true;
        this.handcuffedBy = handcuffedBy;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.GlglKYQV0V6vHcf, this.handcuffed);
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.saEucXqa7hk9o6s, handcuffedBy.toString());
    }

    @Override
    public void unhandcuffPlayer() {
        this.handcuffed = false;
        this.handcuffedBy = null;
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.GlglKYQV0V6vHcf, this.handcuffed);
        tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(this.uuid, httHooAopOc0CwK.saEucXqa7hk9o6s, null);
    }

    @Override
    public boolean isHandCuffed() {
        return this.handcuffed;
    }

    @Override
    public UUID getHandcuffedBy() {
        return this.handcuffedBy;
    }

    @Override
    public void reset() {
        try (Connection connection = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "DELETE FROM Players WHERE UUID=?");
            statement.setString(1, this.uuid.toString());
            statement.execute();
            statement.close();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        PlayerManager.getInstance().addDefaults(this.uuid);
        this.reloadDataFromDB();
    }
}

