/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.events.player;

import nl.minetopiasdb.api.enums.LevelChangeReason;
import nl.minetopiasdb.api.playerdata.objects.SDBPlayer;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class PlayerChangeLevelEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled = false;
    private SDBPlayer player;
    private LevelChangeReason reason;

    public PlayerChangeLevelEvent(SDBPlayer player, LevelChangeReason reason) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.player = player;
        this.reason = reason;
    }

    public SDBPlayer getPlayer() {
        return this.player;
    }

    public LevelChangeReason getLevelChangeReason() {
        return this.reason;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public static boolean setLevel(SDBPlayer target, int newLevel, LevelChangeReason changeReason) {
        PlayerChangeLevelEvent event = new PlayerChangeLevelEvent(target, changeReason);
        Bukkit.getPluginManager().callEvent((Event)event);
        return event.isCancelled();
    }
}

