/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api.banking;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import nl.minetopiasdb.api.banking.Bankaccount;
import nl.minetopiasdb.api.enums.BankAccountType;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ;
import nl.minetopiasdb.plugin.utils.LuZKeqZZNinpwYh;

public class BankUtils {
    private static BankUtils instance;
    private static HashMap<Integer, Bankaccount> cachedAccounts;
    private DecimalFormat decimalFormat = new DecimalFormat("#,##0.00");
    private DecimalFormat decimalFormatNoComma = new DecimalFormat("#,###");

    public static BankUtils getInstance() {
        if (instance == null) {
            instance = new BankUtils();
        }
        return instance;
    }

    public Bankaccount getBankAccount(int id) {
        return cachedAccounts.get(id);
    }

    public List<Bankaccount> getAccounts(BankAccountType ... accountTypes) {
        ArrayList<Bankaccount> accounts = new ArrayList<Bankaccount>();
        for (Bankaccount acc : cachedAccounts.values()) {
            if (!Arrays.asList(accountTypes).contains((Object)acc.getType())) continue;
            accounts.add(acc);
        }
        return accounts;
    }

    public List<Bankaccount> getAccounts(UUID uuid) {
        ArrayList<Bankaccount> accounts = new ArrayList<Bankaccount>();
        for (Bankaccount acc : cachedAccounts.values()) {
            if (!acc.getAuthorisedUsers().contains(uuid)) continue;
            accounts.add(acc);
        }
        return accounts;
    }

    public List<Bankaccount> getAccounts(UUID uuid, BankAccountType ... accountTypes) {
        ArrayList<Bankaccount> accounts = new ArrayList<Bankaccount>();
        for (Bankaccount acc : this.getAccounts(uuid)) {
            if (!Arrays.asList(accountTypes).contains((Object)acc.getType())) continue;
            accounts.add(acc);
        }
        return accounts;
    }

    public void pullCache() {
        cachedAccounts.clear();
        try (Connection connection = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT * FROM Bankaccount");
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                int id = rs.getInt("bankId");
                double balance = rs.getDouble("balance");
                String typeString = rs.getString("bankAccountType");
                String name = rs.getString("bankAccountName");
                BankAccountType type = BankAccountType.valueOf(typeString);
                Bankaccount acc = new Bankaccount(id, type, balance, name, new ArrayList<UUID>());
                cachedAccounts.put(id, acc);
            }
            rs.close();
            statement.close();
            PreparedStatement userStatement = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "SELECT * FROM BankaccountUsers");
            ResultSet userRs = userStatement.executeQuery();
            while (userRs.next()) {
                int id = userRs.getInt("bankId");
                String uuidStr = userRs.getString("UUID");
                UUID uuid = UUID.fromString(uuidStr);
                if (cachedAccounts.get(id) == null) continue;
                cachedAccounts.get(id).addUser(uuid);
            }
            userRs.close();
            userStatement.close();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public void toDatabase() {
        try (Connection connection = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            for (Bankaccount bank : cachedAccounts.values()) {
                PreparedStatement statement = connection.prepareStatement("UPDATE `Bankaccount` SET `balance`=?, `bankAccountName`=? WHERE `bankId`=?");
                statement.setDouble(1, bank.getBalance());
                statement.setString(2, bank.getName());
                statement.setInt(3, bank.getId());
                statement.execute();
                statement.close();
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public void clearCache() {
        cachedAccounts.clear();
    }

    public String format(double number) {
        if (wkMvHiTHLyqFIhJ.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ("MoneyFormatting.HasDecimal")) {
            return this.decimalFormat.format(number).replace(",", "tmp").replace(".", ",").replace("tmp", ".");
        }
        return this.decimalFormatNoComma.format(number).replace(",", ".");
    }

    public int create(BankAccountType type) throws IllegalArgumentException {
        int n;
        block10: {
            if (type == BankAccountType.PERSONAL) {
                throw new IllegalArgumentException("Can't create a personal bank account!");
            }
            Connection connection = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();
            try {
                PreparedStatement statement = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "INSERT INTO `Bankaccount`(`balance`, `bankAccountType`, `bankAccountName`) VALUES (?, ?, ?)", 1);
                statement.setDouble(1, 0.0);
                statement.setString(2, type.getTypeName());
                statement.setString(3, "Loading..");
                statement.executeUpdate();
                ResultSet rs = statement.getGeneratedKeys();
                int last_inserted_id = -1;
                if (rs.next()) {
                    last_inserted_id = rs.getInt(1);
                    PreparedStatement updateName = connection.prepareStatement("UPDATE `Bankaccount` SET `bankAccountName`=? WHERE bankId=?");
                    updateName.setString(1, "&fID: " + last_inserted_id);
                    updateName.setInt(2, last_inserted_id);
                    updateName.execute();
                    updateName.close();
                }
                statement.close();
                rs.close();
                LuZKeqZZNinpwYh.wkMvHiTHLyqFIhJ("BACREATE", last_inserted_id + "=splt=" + type.name());
                this.silentlyCreateBankaccount(last_inserted_id, type);
                n = last_inserted_id;
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                    return -1;
                }
            }
            connection.close();
        }
        return n;
    }

    public void delete(int id) {
        try (Connection connection = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().wkMvHiTHLyqFIhJ(connection, "DELETE FROM `Bankaccount` WHERE bankId=?");
            statement.setInt(1, id);
            statement.execute();
            statement.close();
            PreparedStatement userStatement = connection.prepareStatement("DELETE FROM `BankaccountUsers` WHERE bankId=?");
            userStatement.setInt(1, id);
            userStatement.execute();
            userStatement.close();
            cachedAccounts.remove(id);
            LuZKeqZZNinpwYh.wkMvHiTHLyqFIhJ("BADELETE", "" + id);
            this.silentlyDeleteBankaccount(id);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public void silentlyCreateBankaccount(int id, BankAccountType type) {
        cachedAccounts.put(id, new Bankaccount(id, type, 0.0, "&fID: " + id, new ArrayList<UUID>()));
    }

    public void silentlyDeleteBankaccount(int id) {
        cachedAccounts.remove(id);
    }

    public int getSlots(int accounts) {
        if (accounts <= 18) {
            return 18;
        }
        if (accounts > 45) {
            return 54;
        }
        if (accounts > 36) {
            return 45;
        }
        if (accounts > 27) {
            return 36;
        }
        if (accounts > 18) {
            return 27;
        }
        return 18;
    }

    static {
        cachedAccounts = new HashMap();
    }
}

