/*
 * Decompiled with CFR 0.152.
 */
package nl.minetopiasdb.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import nl.minetopiasdb.api.objects.CriminalActivity;
import nl.minetopiasdb.plugin.Main;
import nl.minetopiasdb.plugin.tA7f31NNkhn8WMw.httHooAopOc0CwK;
import org.bukkit.Bukkit;

public class CriminalRecordManager {
    private static CriminalRecordManager instance;

    public static CriminalRecordManager getInstance() {
        if (instance == null) {
            instance = new CriminalRecordManager();
        }
        return instance;
    }

    public List<CriminalActivity> getCriminalActivities(UUID uuid) {
        ArrayList<CriminalActivity> activities = new ArrayList<CriminalActivity>();
        try (Connection connection = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
            PreparedStatement statement = connection.prepareStatement("SELECT `rowId`, `description` FROM CriminalRecords WHERE UUID=?");
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                activities.add(new CriminalActivity(rs.getInt("rowId"), rs.getString("description")));
            }
            rs.close();
            statement.close();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return activities;
    }

    public void addCriminalActivity(final UUID uuid, final String description) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try (Connection connection = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                    PreparedStatement statement = connection.prepareStatement("INSERT INTO CriminalRecords (UUID, description) VALUES (?, ?)");
                    statement.setString(1, uuid.toString());
                    statement.setString(2, description);
                    statement.execute();
                    statement.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    public void deleteCriminalActivity(final UUID uuid, final String description) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try (Connection connection = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                    PreparedStatement statement = connection.prepareStatement("DELETE FROM CriminalRecords WHERE UUID=? AND description=?");
                    statement.setString(1, uuid.toString());
                    statement.setString(2, description);
                    statement.execute();
                    statement.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
    }

    public void deleteCriminalActivity(final UUID uuid, final int id) {
        Bukkit.getScheduler().runTaskAsynchronously(Main.getPlugin(), new Runnable(){

            @Override
            public void run() {
                try (Connection connection = httHooAopOc0CwK.wkMvHiTHLyqFIhJ().httHooAopOc0CwK();){
                    PreparedStatement statement = connection.prepareStatement("DELETE FROM CriminalRecords WHERE UUID=? AND rowId=?");
                    statement.setString(1, uuid.toString());
                    statement.setInt(2, id);
                    statement.execute();
                    statement.close();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        });
    }
}

